﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_IHidTemporaryServer.sfdl.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace hid { namespace detail {

//!< hid 一時利用機能サービスを扱うクラスです。
class HidTemporaryServer final
{
    NN_DISALLOW_COPY(HidTemporaryServer);
    NN_DISALLOW_MOVE(HidTemporaryServer);

public:
    HidTemporaryServer() NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorCalibrationValues(nn::sf::Out<nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues> outValue,
                                                          nn::applet::AppletResourceUserId aruid,
                                                          nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;
};

//!< hid デバッグ機能サービスのプロクシを作成します。
::nn::Result CreateHidTemporaryServerProxy(
    ::nn::sf::SharedPointer<IHidTemporaryServer>* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
