﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

#include "hid_HandheldImpl.h"
#include "hid_HidSystemServer.h"

namespace nn { namespace hid { namespace detail {

::nn::Result EnableHandheldHids() NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->EnableHandheldHids());
    NN_RESULT_SUCCESS;
}

::nn::Result DisableHandheldHids() NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->DisableHandheldHids());
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
