﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_BitPack.h>

#include "hid_GcAdapterDriver.h"

namespace nn { namespace hid { namespace detail {

GcAdapterDriver::GcAdapterDriver() NN_NOEXCEPT
{
    // 何もしない
}

bool GcAdapterDriver::IsGcAdapter(int vid, int pid) NN_NOEXCEPT
{
    NN_UNUSED(vid);
    NN_UNUSED(pid);
    return false;
}

void GcAdapterDriver::Enable() NN_NOEXCEPT
{
    // 何もしない
}

bool GcAdapterDriver::Attach(size_t port, ::nn::ahid::Ahid& ahid) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(ahid);
    return false;
}

void GcAdapterDriver::Detach(size_t port) NN_NOEXCEPT
{
    NN_UNUSED(port);
}

void GcAdapterDriver::ParseInputReport(size_t port, const uint8_t* pReport, size_t length) NN_NOEXCEPT
{
    NN_UNUSED(port);
    NN_UNUSED(pReport);
    NN_UNUSED(length);
}

bool GcAdapterDriver::SendOutputReport(size_t port) NN_NOEXCEPT
{
    NN_UNUSED(port);
    return false;
}

GcAdapterList GcAdapterDriver::ListAdapters() NN_NOEXCEPT
{
    GcAdapterList list;
    list.count = 0;
    return list;
}

bool GcAdapterDriver::GetState(GcControllerState* pOutValue, const GcControllerIndex& index) NN_NOEXCEPT
{
    NN_UNUSED(pOutValue);
    NN_UNUSED(index);
    return false;
}

Result GcAdapterDriver::ControlMotor(const GcControllerIndex& index, GcControllerMotorState motor) NN_NOEXCEPT
{
    NN_UNUSED(motor);
    NN_UNUSED(index);
    NN_RESULT_THROW(ResultGcControllerNotConnected());
}

GcControllerMotorState GcAdapterDriver::GetMotorState(const GcControllerIndex& index) NN_NOEXCEPT
{
    NN_UNUSED(index);
    return GcControllerMotorState_Off;
}

Result GcAdapterDriver::GetLeftAnalogStickCalibration(AnalogStickState* pOutCenter,
                                                      int16_t* pOutOriginPlay,
                                                      int16_t* pOutRange,
                                                      const GcControllerIndex& index) NN_NOEXCEPT
{
    NN_UNUSED(pOutCenter);
    NN_UNUSED(pOutOriginPlay);
    NN_UNUSED(pOutRange);
    NN_UNUSED(index);

    NN_RESULT_THROW(ResultGcControllerNotConnected());
}

Result GcAdapterDriver::GetRightAnalogStickCalibration(AnalogStickState* pOutCenter,
                                                       int16_t* pOutOriginPlay,
                                                       int16_t* pOutRange,
                                                       const GcControllerIndex& index) NN_NOEXCEPT
{
    NN_UNUSED(pOutCenter);
    NN_UNUSED(pOutOriginPlay);
    NN_UNUSED(pOutRange);
    NN_UNUSED(index);

    NN_RESULT_THROW(ResultGcControllerNotConnected());
}

Result GcAdapterDriver::ControlMotorOnConnect(const GcControllerIndex& index) NN_NOEXCEPT
{
    NN_UNUSED(index);

    NN_RESULT_THROW(ResultGcControllerNotConnected());
}

}}} // namespace nn::hid::detail
