﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/debug/hid_FirmwareUpdate.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_UniquePad.h>

namespace nn { namespace hid { namespace debug { namespace detail {

::nn::Result InitializeFirmwareUpdate() NN_NOEXCEPT;

::nn::Result StartFirmwareUpdate(system::UniquePadId id) NN_NOEXCEPT;

::nn::Result StartFirmwareUpdateForRevert(system::UniquePadId id) NN_NOEXCEPT;

::nn::Result GetFirmwareVersion(debug::FirmwareVersion* pOutValue,
                                NpadIdType id,
                                system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;

::nn::Result GetAvailableFirmwareVersionForRevert(system::FirmwareVersion* pOutValue,
                                                  system::UniquePadId id) NN_NOEXCEPT;

::nn::Result GetDestinationFirmwareVersion(debug::FirmwareVersion* pOutValue,
                                           NpadIdType id,
                                           system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;

::nn::Result GetFirmwareUpdateStage(debug::FirmwareUpdateStage* pOutStage, uint8_t* pOutProgress) NN_NOEXCEPT;

::nn::Result IsFirmwareUpdatingDevice(bool* pOutIsUpdating,
                                      system::UniquePadId id) NN_NOEXCEPT;

::nn::Result StartFirmwareUpdateIndividual(
    system::FirmwareUpdateDeviceHandle* pOutDeviceHandle,
    system::UniquePadId id,
    FirmwareUpdateTargetChip target,
    char* pImageData,
    size_t imageSize) NN_NOEXCEPT;

}}}} // namespace nn::hid::debug::detail
