﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_ExternalBus.h>

#include <nn/nn_SdkLog.h>

#include "hid_NpadId.h"
#include "hid_NpadRailAttachmentTypes.h"

namespace nn { namespace hid { namespace detail {

//!< ExternalBusHandle から NpadJoyConRailIndex を取得します。
nn::Result GetNpadJoyConRailIndexFromExternalBusHandle(NpadJoyConRailIndex* pOutRailIndex, const ExternalBusHandle& handle) NN_NOEXCEPT;

//!< ExternalBusHandle からプレイヤー番号を取得します。(TODO : NpadIdType にした方がよさそう)
int GetExternalBusHandlePlayerNumber(const ExternalBusHandle& handle) NN_NOEXCEPT;

//!< ExternalBusHandle から BusTypeId を取得します。
int GetExternalBusHandleBusTypeId(const ExternalBusHandle& handle) NN_NOEXCEPT;

//!< ExternalBusHandle から InternalIndex を取得します。
int GetExternalBusHandleInternalIndex(const ExternalBusHandle& handle) NN_NOEXCEPT;

//!< ExternalBusHandle を取得します。
bool GetExternalBusHandle(ExternalBusHandle* pOutHandle, const nn::hid::NpadIdType &id, ExternalBusType busType) NN_NOEXCEPT;

//!< 有効な handle かどうかを確認します。
nn::Result CheckValidExternalBusHandle(ExternalBusHandle handle) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
