﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/debug/hid_DebugPad.h>

namespace nn { namespace hid { namespace detail {

::nn::Result InitializeDebugPad() NN_NOEXCEPT;

::nn::Result FinalizeDebugPad() NN_NOEXCEPT;

::nn::Result GetDebugPadState(DebugPadState* pOutValue) NN_NOEXCEPT;

::nn::Result GetDebugPadStates(
    int* pOutCount, DebugPadState outValues[], int count) NN_NOEXCEPT;

::nn::Result SetDebugPadAutoPilotState(
    const ::nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT;

::nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::detail
