﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/settings/settings_DebugPad.h>

#include "hid_ActivationCount.h"
#include "hid_DebugPadMappingManager.h"
#include "hid_IDebugPadDriver.h"
#include "hid_WindowsGenericPad-os.win.h"
#include "hid_WindowsKeyboard-os.win.h"

namespace nn { namespace hid { namespace detail {

class DebugPadDriver final : public IDebugPadDriver
{
    NN_DISALLOW_COPY(DebugPadDriver);
    NN_DISALLOW_MOVE(DebugPadDriver);

private:
    //!< アクティブ化した回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< マッピングマネージャを指すポインタ
    DebugPadMappingManager* m_pMappingManager;

    //!< Windows の汎用コントローラ
    WindowsGenericPad m_WindowsGenericPad;

    //!< Windows のキーボード
    WindowsKeyboard m_WindowsKeyboard;

    //!< 汎用ゲームパッドの割り当て
    ::nn::settings::DebugPadGenericPadMap m_GenericPadMap;

    //!< キーボードの割り当て
    ::nn::settings::DebugPadKeyboardMap m_KeyboardMap;

public:
    DebugPadDriver() NN_NOEXCEPT;

    virtual ~DebugPadDriver() NN_NOEXCEPT NN_OVERRIDE;

    void SetMappingManager(DebugPadMappingManager* pMappingManager) NN_NOEXCEPT;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(DebugPadState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
