﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/applet/applet_Types.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/os/os_SdkMutex.h>

#include "hid_AppletResourceManager.h"
#include "hid_ConsoleSixAxisSensorAppletSetting.h"

namespace nn { namespace hid { namespace detail {

//!< アプリケーション毎の SixAxisSensor の設定値管理クラス
class ConsoleSixAxisSensorAppletSettingManager final
{
    NN_DISALLOW_COPY(ConsoleSixAxisSensorAppletSettingManager) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(ConsoleSixAxisSensorAppletSettingManager) NN_NOEXCEPT;

private:

    //!< プロセスが全く存在しないときに用いられる設定値
    ConsoleSixAxisSensorSetting m_EmptySetting;

    //!< アプレットリソースマネージャ
    AppletResourceManager* m_pAppletResourceManager;

    //!< アプレットリソースマネージャのミューテックス
    ::nn::os::SdkRecursiveMutex* m_pAppletResourceManagerMutex;

public:
    ConsoleSixAxisSensorAppletSettingManager() NN_NOEXCEPT;
    ~ConsoleSixAxisSensorAppletSettingManager() NN_NOEXCEPT;

    //!< アプレットリソースマネージャを設定します。
    void SetAppletResourceManager(AppletResourceManager* pManager, ::nn::os::SdkRecursiveMutex* pMutex) NN_NOEXCEPT;

    ::nn::applet::AppletResourceUserId GetFocusedAppletResourceUserId() NN_NOEXCEPT;

    void GetAppletResourceUserId(::nn::applet::AppletResourceUserId* pOutValues, int count) const NN_NOEXCEPT;

    Result GetConsoleSixAxisSensorSetting(ConsoleSixAxisSensorSetting** pOutSetting,
                                          ::nn::applet::AppletResourceUserId aruid,
                                          const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

private:
    ConsoleSixAxisSensorAppletSetting* GetFocusedSetting() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
