﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/debug/hid_CaptureButton.h>
#include <nn/hid/system/hid_CaptureButton.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace hid { namespace detail {

::nn::Result BindCaptureButtonEvent(::nn::os::SystemEventType* pEvent,
                                  ::nn::os::EventClearMode clearMode
                                  ) NN_NOEXCEPT;

::nn::Result InitializeCaptureButton() NN_NOEXCEPT;

::nn::Result FinalizeCaptureButton() NN_NOEXCEPT;

::nn::Result GetCaptureButtonStates(
    int* pOutCount,
    ::nn::hid::system::CaptureButtonState outStates[],
    int count) NN_NOEXCEPT;

::nn::Result SetCaptureButtonAutoPilotState(
    const ::nn::hid::debug::CaptureButtonAutoPilotState& value) NN_NOEXCEPT;

::nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::detail
