﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>
#include <nn/util/util_BitPack.h>

#include "hid_ActivationCount.h"
#include "hid_IAudioControlDriver.h"

namespace nn { namespace hid { namespace detail {

struct AudioControlReport final
{
    int32_t VolumeIncrement;
    int32_t VolumeDecrement;
    int32_t Mute;
    int32_t Stop;
};

class AudioControlDriver final : public IAudioControlDriver
{
    NN_DISALLOW_COPY(AudioControlDriver);
    NN_DISALLOW_MOVE(AudioControlDriver);

public:
    //!< ポートの数
    static const size_t PortCount = 8;

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< アタッチ状態にあるポートの数
    ::std::atomic<int> m_Count;

    //!< レポート
    ::std::atomic<AudioControlReport> m_Reports[PortCount];

    ::std::atomic<bool> m_HasNewReport;

public:
    AudioControlDriver() NN_NOEXCEPT;

    virtual ~AudioControlDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(system::AudioControlState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< アタッチ処理を行います。
    void Attach(size_t port);

    //!< デタッチ処理を行います。
    void Detach(size_t port);

    //!< レポートを設定します。
    void SetReport(size_t port, AudioControlReport& reports) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail

