﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       アタッチメントの検出処理に特化したクラスの宣言
 */

#pragma once

#include <nn/hid/hid_SixAxisSensor.h>

namespace nn { namespace hid { namespace detail {

//!< アタッチメントの検出処理を担うクラス
class AttachmentDetector final
{
    NN_DISALLOW_COPY(AttachmentDetector);
    NN_DISALLOW_MOVE(AttachmentDetector);

private:
    float m_Probability;  //!< アタッチメントに装着されている確率

public:
    AttachmentDetector()  NN_NOEXCEPT;
    ~AttachmentDetector() NN_NOEXCEPT {};

    //!< アタッチメントに装着されている確率を更新します。
    void UpdateProbability(const nn::hid::SixAxisSensorState& left,
                           const nn::hid::SixAxisSensorState& right) NN_NOEXCEPT;

    //!< アタッチメントに装着されている確率をリセットします。
    void ResetProbability() NN_NOEXCEPT;

    //!< アタッチメントに装着されている確率を返します。
    float GetProbability() const NN_NOEXCEPT;

    //!< アタッチメントに装着されているか否かを返します。
    bool IsAttached() const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
