﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>

namespace nn { namespace hid { namespace detail {

::nn::Result SetAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT;

::nn::Result RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT;

::nn::Result UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

::nn::Result EnableAppletToGetInput(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT;

::nn::Result SetAruidValidForVibration(
    const ::nn::applet::AppletResourceUserId& aruid, bool enable) NN_NOEXCEPT;

::nn::Result EnableAppletToGetSixAxisSensor(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
