﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

#include "hid_AbstractedPadIdPublisher.h"
#include "hid_AbstractedPadUsb.h"
#include "hid_ActivationCount.h"
#include "hid_MultiWaitEvent.h"

namespace nn { namespace hid { namespace detail {

//!< Usb のデバイス管理を担うマネージャーです
class AbstractedPadUsbDriver final
{
    NN_DISALLOW_COPY(AbstractedPadUsbDriver) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(AbstractedPadUsbDriver) NN_NOEXCEPT;

public:
    //!< Usb デバイスの扱える最大数
    static const size_t PortCount = 8;

private:
    //!< AbstractedPad のリスト
    AbstractedPadUsb* m_pPads[PortCount];

    //!< AbstractedPad の数
    int m_PadCount;

    //!< アクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< AbstractedId パブリッシャー
    AbstractedPadIdPublisher* m_pIdPublisher;

public:
    AbstractedPadUsbDriver() NN_NOEXCEPT;

    ~AbstractedPadUsbDriver() NN_NOEXCEPT;

    //!< AbstractedId パブリッシャーをセットします
    void SetAbstractedPadIdPublisher(AbstractedPadIdPublisher* pPublisher) NN_NOEXCEPT;

    //!< AbstractedPadUsb をセットします
    void SetAbstractedPadUsbs(AbstractedPadUsb* pPads, int count) NN_NOEXCEPT;

    //!< マネージャをアクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< マネージャを非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< 新規にデバイスを登録する。
    void Attach(size_t port, uint16_t vid, uint16_t pid) NN_NOEXCEPT;

    //!< 登録済みのデバイスを切断する。
    void Detach(size_t port) NN_NOEXCEPT;

    //!< Input Report を設定します。
    void SetReport(size_t port, const uint8_t* pReport, size_t length) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
