﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/hid/system/hid_Result.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_AbstractedPadManager.h"

namespace nn { namespace hid { namespace detail {

AbstractedPadManager::AbstractedPadManager() NN_NOEXCEPT
{
    // 何もしない
}

AbstractedPadManager::~AbstractedPadManager() NN_NOEXCEPT
{
    // 何もしない
}

void AbstractedPadManager::Initialize() NN_NOEXCEPT
{
}

void AbstractedPadManager::AddIAbstractedPad(IAbstractedPad* pPads) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPads);
    NN_SDK_REQUIRES(m_ActivationCount.IsZero());
    m_pAbstractedPads[m_AbstractedPadCount] = pPads;
    m_AbstractedPadCount++;
}

::nn::Result AbstractedPadManager::Activate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsMax(),
                           ResultGamePadDriverActivationUpperLimitOver());

    if (m_ActivationCount.IsZero())
    {
    }

    // アクティブ化した回数をインクリメント
    ++m_ActivationCount;

    NN_RESULT_SUCCESS;
}

::nn::Result AbstractedPadManager::Deactivate() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!m_ActivationCount.IsZero(),
                           ResultGamePadDriverDeactivationLowerLimitOver());

    // アクティブ化した回数をデクリメント
    --m_ActivationCount;

    if(m_ActivationCount.IsZero())
    {
    }

    NN_RESULT_SUCCESS;
}

Result AbstractedPadManager::GetActiveAbstractedPadIds(int* pOutCount, AbstractedPadId* pOutIds, int count) NN_NOEXCEPT
{
    auto gotCount = 0;

    for (int i = 0; i < m_AbstractedPadCount; i++)
    {
        if (gotCount < count && m_pAbstractedPads[i]->IsConnected())
        {
            pOutIds[gotCount++] = m_pAbstractedPads[i]->GetId();
            if (gotCount >= count)
            {
                break;
            }
        }
    }
    *pOutCount = gotCount;

    NN_RESULT_SUCCESS;
}

Result AbstractedPadManager::GetAbstractedPad(IAbstractedPad** pOutPad, AbstractedPadId id) NN_NOEXCEPT
{
    // 接続済みのデバイスを処理
    for (int i = 0; i < m_AbstractedPadCount; i++)
    {
        auto pPads = m_pAbstractedPads[i];
        if (pPads->IsConnected() == true &&
            pPads->GetId() == id)
        {
            *pOutPad = pPads;
            NN_RESULT_SUCCESS;
        }
    }
    NN_RESULT_THROW(ResultNoNpadAssignedForXcdHandle()); // TODO:エラー定義
}


}}} // namespace nn::hid::detail
