﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/hid/debug/hid_AbstractedPad.h>

namespace nn { namespace hid { namespace detail {

    ::nn::Result SetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId, const ::nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT;
    ::nn::Result UnsetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId) NN_NOEXCEPT;
    ::nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT;
    ::nn::Result GetAbstractedPadHandles(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, int count) NN_NOEXCEPT;
    ::nn::Result GetAbstractedPadState(debug::AbstractedPadState* pOutState, ::nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT;
    ::nn::Result GetAbstractedPadsState(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, debug::AbstractedPadState* pOutStates, int count) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
