﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/detail/hid_AbstractedPadTypes.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace hid { namespace detail {

class AbstractedPadIdPublisher final
{
    NN_DISALLOW_COPY(AbstractedPadIdPublisher) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(AbstractedPadIdPublisher) NN_NOEXCEPT;

private:
    //!< 最後に発行された Id の値
    AbstractedPadId m_LatestId;

    //!< Id 発行制御のための Mutex
    ::nn::os::Mutex m_Mutex;

public:
    AbstractedPadIdPublisher() NN_NOEXCEPT;

    //!< 新しい Id を発行する
    AbstractedPadId PublishId() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
