﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "../grcsrvOffscreen_Config.h"

#define NN_LOG_SYNCPOINT_I(format,...) \
    NN_GRCSRV_OFFSCRN_LOG_DEV("(%d)" format, nn::os::GetThreadId(nn::os::GetCurrentThread()), __VA_ARGS__);

#define NN_LOG_SYNCPOINT_ERR_I(format,...) \
    NN_GRCSRV_OFFSCRN_LOG_DEV("(%d)[err]" format, nn::os::GetThreadId(nn::os::GetCurrentThread()), __VA_ARGS__);

#define NN_LOG_SYNCPOINT_DEV_I(format,...) \
    NN_GRCSRV_OFFSCRN_LOG_DEV("(%d)" format, nn::os::GetThreadId(nn::os::GetCurrentThread()), __VA_ARGS__);

#define NN_LOG_SYNCPOINT(...) NN_LOG_SYNCPOINT_I(__VA_ARGS__, 0)
#define NN_LOG_SYNCPOINT_ERR(...) NN_LOG_SYNCPOINT_ERR_I(__VA_ARGS__, 0)
#define NN_LOG_SYNCPOINT_DEV(...) NN_LOG_SYNCPOINT_DEV_I(__VA_ARGS__, 0)
