﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{
    class SyncpointEntry;
}}}}

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{ namespace detail{

    class SyncpointWaiterQueue
    {
    public:
        static const int Capacity = 15;
        static const int Size = Capacity + 1;
    public:
        SyncpointWaiterQueue() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // この関数が呼ばれた瞬間において、キューが空かを返す。
        // 一般にこの関数から返った直後に他のスレッドが Enqueue する可能性がある。
        // 他のスレッドとの排他は別途行うこと。
        bool IsEmpty() NN_NOEXCEPT;

        void Enqueue(SyncpointEntry* pEntry) NN_NOEXCEPT;

        // キャンセルされていた場合 nullptr が取得される。
        void Dequeue(SyncpointEntry** pOutEntry) NN_NOEXCEPT;

        // 対象が存在したらキャンセルして true を返す。
        // 対象が存在しなければ何もせずに false を返す。
        // キャンセルされたエントリーは nullptr になる。
        bool Cancel(SyncpointEntry* pEntry) NN_NOEXCEPT;

        void InitializeDequeueMultiWaitHolder(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;
        void FinalizeDequeueMultiWaitHolder(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;
    private:
        nn::Result EnqueueImpl(SyncpointEntry* pEntry) NN_NOEXCEPT;
        nn::Result DequeueImpl(SyncpointEntry** pOutEntry) NN_NOEXCEPT;

    private:
        SyncpointEntry* m_EntryList[Size];
        int m_HeadIndex;
        int m_TailIndex;

        nn::os::MutexType m_Mutex;
        nn::os::SemaphoreType m_EnqueueSemaphore;
        nn::os::SemaphoreType m_DequeueSemaphore;
    };

}}}}}
