﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "grcsrv_OffscreenRecorder.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/grc/grc_Result.h>
#include "grcsrv_OffscreenMacro.h"

namespace nerd{ namespace scoop{
    nn::Result InitializeAllocators(void*, const size_t);
    void FinalizeAllocators();
}}

namespace nn{ namespace grcsrv{ namespace offscreen{

    namespace {
        bool g_IsInitialized = false;
    }

    nn::Result InitializeOffscreenRecordingSystem(void* pMemory, size_t memorySize) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(g_IsInitialized, nn::grc::ResultInvalidState());

        NN_GRCSRV_OFFSCRN_PROCESS_START();

        NN_RESULT_DO(nerd::scoop::InitializeAllocators(pMemory, memorySize));
        NN_GRCSRV_OFFSCRN_PROCESS_ROLLBACK(nerd::scoop::FinalizeAllocators());

        NN_GRCSRV_OFFSCRN_PROCESS_SUCCESS();
        g_IsInitialized = true;
        NN_RESULT_SUCCESS;
    }

    void FinalizeOffscreenRecordingSystem() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_IsInitialized);

        nerd::scoop::FinalizeAllocators();

        g_IsInitialized = false;
    }

}}}
