﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn{ namespace grcsrv{ namespace offscreen{

    class MultiWaitHandler
    {
    public:
        MultiWaitHandler() NN_NOEXCEPT;

        nn::os::MultiWaitHolderType* GetHolder() NN_NOEXCEPT;

        bool IsLinked() const NN_NOEXCEPT;

        // Link 状態にする。 IsLinked だった場合、一旦 Unlink してから Link しなおす。
        void Link(void (*onSignal)(MultiWaitHandler* pHandler, void* userPtr), void* userPtr) NN_NOEXCEPT;
        // Unlink 状態にする。!IsLinked だった場合、何もしない。
        void Unlink() NN_NOEXCEPT;

    private:
        static void CallbackImpl(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked, void* userPtr) NN_NOEXCEPT;

    private:
        nn::os::MultiWaitHolderType m_Holder;
        void (*m_Callback)(MultiWaitHandler*, void*);
        void* m_UserPtr;
    };

    void LinkMultiWait(
        nn::os::MultiWaitHolderType* pHolder,
        void (onSignal)(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked, void* userPtr),
        void* userPtr
    ) NN_NOEXCEPT;

    void UnlinkMultiWait(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

}}}
