﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SdkLog.h>

//---------------
// 設定
//---------------

#define NN_GRCSRV_OFFSCRN_PROXYNAME "grc"

namespace nn{ namespace grcsrv{ namespace offscreen{

    //static const int RecordingVideoWidthMax  = 1280;
    //static const int RecordingVideoHeightMax = 720;
    static const int RecordingVideoWidthMax  = 1920;
    static const int RecordingVideoHeightMax = 1080;
    static const int VideoCaptureImageBufferCount = 2;
    static const int ClientImageBufferCountMax    = 16;

    static const size_t LibraryStateMemorySize = 10 * 1024;
    static const size_t ImageBufferMemorySize  = 12 * 1024 * 1024;
    static const size_t MovieFileMemorySize    = 260 * 1024;
    static const size_t MultimediaHeapSize     = 80 * 1024 * 1024;
    static const size_t RequiredTransferMemorySize =
        LibraryStateMemorySize +
        ImageBufferMemorySize +
        MovieFileMemorySize +
        MultimediaHeapSize;

    NN_STATIC_ASSERT(RequiredTransferMemorySize <= 96 * 1024 * 1024);

}}}

//--------------
// ログ
//--------------
#define NN_GRCSRV_BINDER_ENABLE_TOSTRING

#define NN_GRCSRV_OFFSCRN_LOG_ROOT(...) NN_SDK_LOG("[grc#]" __VA_ARGS__)

#define NN_GRCSRV_OFFSCRN_LOG_WARN(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[WARN]" __VA_ARGS__)
#define NN_GRCSRV_OFFSCRN_LOG_ERR(...)  NN_GRCSRV_OFFSCRN_LOG_ROOT("[ERROR]" __VA_ARGS__)

#define NN_GRCSRV_OFFSCRN_LOG_PROCESS_TRACE(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[err]" __VA_ARGS__)

#define NN_GRCSRV_OFFSCRN_LOG_DEV(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[dev]" __VA_ARGS__)

// Transaction
#define NN_GRCSRV_OFFSCRN_LOG_DEV_TRANSACT(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[tr]" __VA_ARGS__)

// ImageBuffer
#define NN_GRCSRV_OFFSCRN_LOG_DEV_IMGBUF(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[imgbuf]" __VA_ARGS__)

// Layer
#define NN_GRCSRV_OFFSCRN_LOG_DEV_LAYER(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[layer]" __VA_ARGS__)

// VideoRendererHandler
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VIDEORENDERER(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[vren]" __VA_ARGS__)

// VideoCaptureHandler
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VIDEOCAPTURE(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[vcap]" __VA_ARGS__)

// VideoEncoderHandler
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VIDEOENCODER(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[venc]" __VA_ARGS__)

// AudioRendererHandler
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AUDIORENDERER(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[aren]" __VA_ARGS__)

// AudioEncoderHandler
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AUDIOENCODER(...) //NN_GRCSRV_OFFSCRN_LOG_ROOT("[aenc]" __VA_ARGS__)

// VideoEncodeThread
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VENCT(...)     //NN_GRCSRV_OFFSCRN_LOG_ROOT("[vet]" __VA_ARGS__)
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VENCT_ERR(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[vet][err]" __VA_ARGS__)

// VideoMuxerThread
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VMUXT(...)     //NN_GRCSRV_OFFSCRN_LOG_ROOT("[vmt]" __VA_ARGS__)
#define NN_GRCSRV_OFFSCRN_LOG_DEV_VMUXT_ERR(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[vmt][err]" __VA_ARGS__)

// AudioEncodeThread
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AENCT(...)     //NN_GRCSRV_OFFSCRN_LOG_ROOT("[aet]" __VA_ARGS__)
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AENCT_ERR(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[aet][err]" __VA_ARGS__)

// AudioMuxerThread
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AMUXT(...)     //NN_GRCSRV_OFFSCRN_LOG_ROOT("[amt]" __VA_ARGS__)
#define NN_GRCSRV_OFFSCRN_LOG_DEV_AMUXT_ERR(...) NN_GRCSRV_OFFSCRN_LOG_ROOT("[amt][err]" __VA_ARGS__)
