﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/grcsrv/grcsrv_VsyncSystemEvent.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include <nn/vi/sf/vi_ServiceName.h>


namespace nn{ namespace grcsrv{

    namespace {

        class VsyncEventHolder
        {
        public:
            static const size_t ObjectCountMax = 4;

        public:
            VsyncEventHolder() NN_NOEXCEPT
                : m_Manager(NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER)
                , m_RootHolder(NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER)
            {
            }

            void Initialize() NN_NOEXCEPT
            {
                NN_ABORT_UNLESS_RESULT_SUCCESS(m_Manager.InitializeShimLibraryHolder(&m_RootHolder, nn::vi::sf::ApplicationDisplayServiceName, nullptr));
                NN_ABORT_UNLESS_RESULT_SUCCESS(m_RootHolder->GetDisplayService(&m_pAppService, nn::vi::PolicyLevel_Standard));

                nn::vi::DisplayId defaultDisplayId = {};
                NN_ABORT_UNLESS_RESULT_SUCCESS(m_pAppService->OpenDefaultDisplay(&defaultDisplayId));

                {
                    nn::sf::NativeHandle h;
                    NN_ABORT_UNLESS_RESULT_SUCCESS(m_pAppService->GetDisplayVsyncEvent(&h, defaultDisplayId));
                    nn::os::AttachReadableHandleToSystemEvent(&m_VsyncEvent, h.GetOsHandle(), h.IsManaged(), nn::os::EventClearMode_ManualClear);
                    h.Detach();
                }
            }

            nn::os::SystemEventType* GetVsyncEvent() NN_NOEXCEPT
            {
                return &m_VsyncEvent;
            }

        private:
            nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax> m_Manager;
            nn::sf::ShimLibraryObjectHolder<nn::visrv::sf::IApplicationRootService> m_RootHolder;
            nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> m_pAppService;

            nn::os::SystemEventType m_VsyncEvent;
        };

        VsyncEventHolder g_Holder;

    }

    void InitializeVsyncSystemEvent() NN_NOEXCEPT
    {
        g_Holder.Initialize();
    }

    nn::os::SystemEventType* GetVsyncSystemEvent() NN_NOEXCEPT
    {
        return g_Holder.GetVsyncEvent();
    }

}}

