﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>

#include "grcsrv_MovieMakerClient.h"

namespace nn{ namespace grcsrv{
    static const int MovieMakerClientCountMax = 1;

    class MovieMakerImpl
    {
    public:
        explicit MovieMakerImpl(MovieMakerClient* pClient) NN_NOEXCEPT;
        ~MovieMakerImpl() NN_NOEXCEPT;

        nn::Result CreateVideoProxy(nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outProxy) NN_NOEXCEPT;
        nn::Result OpenOffscreenLayer(nn::sf::Out<int32_t> outProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result StartOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result StartOffscreenRecordingEx(std::uint64_t layerHandle, const nn::grcsrv::OffscreenRecordingParameter& paramData) NN_NOEXCEPT;
        nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const sf::InBuffer& userData) NN_NOEXCEPT;
        nn::Result CompleteOffscreenRecordingFinishEx0(std::uint64_t layerHandle, const sf::InBuffer& userData, const sf::InBuffer& thumbnailImage, int thumbnailImageWidth, int thumbnailImageHeight) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle>& outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle>& outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;

    public:
        MovieMakerClient* m_pClient;
    };

    class MovieMakerVideoProxyImpl
    {
    public:
        explicit MovieMakerVideoProxyImpl(MovieMakerClient* pClient) NN_NOEXCEPT;
        ~MovieMakerVideoProxyImpl() NN_NOEXCEPT;

        void TransactParcel(std::int32_t handle, std::uint32_t code, const nn::sf::InBuffer& requestBuffer, const nn::sf::OutBuffer& replyBuffer, std::uint32_t flags) NN_NOEXCEPT;
        void AdjustRefcount(std::int32_t handle, std::int32_t diff, std::int32_t isStrong) NN_NOEXCEPT;
        void GetNativeHandle(std::int32_t handle, std::uint32_t code, nn::sf::Out<nn::sf::NativeHandle> result) NN_NOEXCEPT;
        void TransactParcelAuto(std::int32_t handle, std::uint32_t code, const nn::sf::InBuffer& requestBuffer, const nn::sf::OutBuffer& replyBuffer, std::uint32_t flags) NN_NOEXCEPT;

    public:
        MovieMakerClient* m_pClient;
    };

    class MovieMakerServiceImpl
    {
        friend class MovieMakerImpl;
        friend class MovieMakerVideoProxyImpl;

        enum LockFlag
        {
            LockFlag_MovieMaker = (1 << 0),
            LockFlag_VideoProxy = (1 << 1),
        };

    public:
        MovieMakerServiceImpl() NN_NOEXCEPT;

        nn::Result CreateMovieMaker(nn::sf::Out<nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>> outProxy, nn::applet::AppletResourceUserId aruid, ncm::ApplicationId) NN_NOEXCEPT;

    private:
        bool IsAnyLocked(uint64_t lockMask) const NN_NOEXCEPT;
        nn::Result AcquireAndLock(MovieMakerClient** pOutClient, nn::applet::AppletResourceUserId aruid, ncm::ApplicationId applicationId, uint64_t lockMask) NN_NOEXCEPT;
        void Lock(MovieMakerClient* pClient, uint64_t lockMask) NN_NOEXCEPT;
        void Unlock(MovieMakerClient* pClient, uint64_t lockMask) NN_NOEXCEPT;

    private:
        nn::util::optional<MovieMakerClient> m_Client;
        uint64_t m_Lock;
    };

}}

