﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "grcsrv_Deactivatable.h"

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace grcsrv {

void DeactivatableHolder::Set(Deactivatable* p) NN_NOEXCEPT
{
    this->m_P = p;
}

bool DeactivatableHolder::Deactivate() NN_NOEXCEPT
{
    if (m_P)
    {
        if (!m_P->Deactivate())
        {
            return false;
        }
        this->m_P = nullptr;
    }
    return true;
}


}}
