﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

#include <nn/sf/sf_NativeHandle.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_ConditionVariable.h>
#include <nn/os/os_Tick.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/grc/grc_CommonTypes.h>
#include "grcsrv_SubTaskThread.h"
#include "grcsrv_TransferMemoryHolder.h"
#include "grcsrv_Deactivatable.h"

namespace nn { namespace fs {
struct FileHandle;
}}

namespace nn { namespace grcsrv {

class MovieFileWriter;
class RecordingNotificator;

class ContinuousRecorderImpl
    : private detail::SubTaskThread
{
private:

    MovieFileWriter* const m_pMovieFileWriter;
    RecordingNotificator* const m_pRecordingNotificator;
    ncm::ApplicationId m_ApplicationId;

    bool m_Initialized = false;
    bool m_ForDebug = false;
    int m_Fps;
    int m_KeyFrameIntervalFrames;
    void FinalizeImpl() NN_NOEXCEPT;

    detail::TransferMemoryHolder m_MemoryHolder;

    void* m_MetaBuffer;
    size_t m_MetaBufferSize;
    void* m_LastFrameYBuffer;
    size_t m_LastFrameYBufferSize;
    void* m_LastFrameUVBuffer;
    size_t m_LastFrameUVBufferSize;

    bool m_IsRecording;
    void StartRecordingImpl() NN_NOEXCEPT;
    void StopRecordingImpl() NN_NOEXCEPT;

    os::Mutex m_FlushMutex{false};
    util::optional<os::SystemEvent> m_pFlushCompletedEvent;

    void FlushImpl() NN_NOEXCEPT;
    Result WriteDataImpl(int* pFrameCount, fs::FileHandle f, TimeSpan timeSpan, int videoOrientation) NN_NOEXCEPT;
    void CancelFlushImpl() NN_NOEXCEPT;

    grc::ContinuousRecordingFlushParameter m_FlushParameter;

    TimeSpan m_MaxRecordingTime;
    TimeSpan m_MinRecordingTime;
    os::Tick m_RecordingStartTick;
    os::Tick m_FlushStartTick;
    void ResetFlushStartTickImpl(os::Tick additionalTick = os::Tick(0)) NN_NOEXCEPT;
    void ResetFlushStartTick() NN_NOEXCEPT;
    TimeSpan GetFlushTimeImpl() NN_NOEXCEPT;

    virtual void DoTask() NN_NOEXCEPT NN_OVERRIDE;
    virtual void DoCancel() NN_NOEXCEPT NN_OVERRIDE;

public:
    NN_IMPLICIT ContinuousRecorderImpl(MovieFileWriter* pMovieFileWriter, RecordingNotificator* pRecordingNotificator) NN_NOEXCEPT;
    Result Initialize(sf::NativeHandle&& workMemoryHandle, uint64_t workMemorySize, const grcsrv::ContinuousRecordingParameter& parameter, int flushThreadPriority, const char* flushThreadName) NN_NOEXCEPT;
    ~ContinuousRecorderImpl() NN_NOEXCEPT;

    Result StartRecording() NN_NOEXCEPT;
    Result StopRecording() NN_NOEXCEPT;
    Result GetNotFlushingEvent(sf::Out<sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    Result StartFlush(sf::NativeHandle* pOut, const grcsrv::ContinuousRecordingFlushParameter& parameter) NN_NOEXCEPT;
    Result CancelFlush() NN_NOEXCEPT;
    Result ResetFlushTime(int64_t additionalTimeNs) NN_NOEXCEPT;

    bool IsFlushing() NN_NOEXCEPT;
};

class ContinuousRecorderImpl2
    : public Deactivatable
{
private:

    util::optional<ContinuousRecorderImpl> m_pImpl;

    MovieFileWriter* m_pMovieFileWriter;
    RecordingNotificator* m_pRecordingNotificator;
    DeactivatableHolder* m_pDeactivatableHolder;
    sf::NativeHandle m_WorkMemoryHandle;
    uint64_t m_WorkMemorySize;
    grcsrv::ContinuousRecordingParameter m_Parameter;
    int m_FlushThreadPriority;
    const char* m_FlushThreadName;

    Result ActivateImpl() NN_NOEXCEPT;
    void DeactivateImpl() NN_NOEXCEPT;

    virtual bool Deactivate() NN_NOEXCEPT NN_OVERRIDE;

public:

    NN_IMPLICIT ContinuousRecorderImpl2(MovieFileWriter* pMovieFileWriter, RecordingNotificator* pRecordingNotificator, DeactivatableHolder* pDeactivatableHolder) NN_NOEXCEPT;
    Result Initialize(sf::NativeHandle&& workMemoryHandle, uint64_t workMemorySize, const grcsrv::ContinuousRecordingParameter& parameter, int flushThreadPriority, const char* flushThreadName) NN_NOEXCEPT;
    ~ContinuousRecorderImpl2() NN_NOEXCEPT;

    Result StartRecording() NN_NOEXCEPT;
    Result StopRecording() NN_NOEXCEPT;
    Result GetNotFlushingEvent(sf::Out<sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    Result StartFlush(const grcsrv::ContinuousRecordingFlushParameter& parameter) NN_NOEXCEPT;
    Result StartFlushWithEvent(sf::Out<sf::NativeHandle> pOut, const grcsrv::ContinuousRecordingFlushParameter& parameter) NN_NOEXCEPT;
    Result CancelFlush() NN_NOEXCEPT;
    Result ResetFlushTime(int64_t additionalTimeNs) NN_NOEXCEPT;

};

}}
