﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if !defined( WIN32_LEAN_AND_MEAN )
    #define WIN32_LEAN_AND_MEAN
#endif
#if !defined( NOMINMAX )
    #define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <nn/gfxTool/gfxTool_DllBase.h>
#include <nn/gfxTool/gfxTool_Util.h>

namespace nn {
namespace gfxTool {

bool DllBase::Initialize( const char* pDllPath ) NN_NOEXCEPT
{
    return ( m_hDll = LoadLibraryA( pDllPath ) ) != nullptr;
}

void DllBase::Finalize() NN_NOEXCEPT
{
    if( m_hDll )
    {
        FreeLibrary( StaticCastAuto( m_hDll ) );
        m_hDll = nullptr;
    }
}

void* DllBase::GetFunctionImpl( const char* pFunctionName ) NN_NOEXCEPT
{
    return GetProcAddress( StaticCastAuto( m_hDll ), pFunctionName );
}

}
}
