﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_StateInfo.h>

namespace nn {
namespace gfx {

void MultisampleStateInfo::SetDefault() NN_NOEXCEPT
{
    SetAlphaToCoverageEnabled( false );
    SetSampleCount( 1 );
    SetSampleMask( 0xFFFFFFFF );
}

void RasterizerStateInfo::SetDefault() NN_NOEXCEPT
{
    SetFillMode( FillMode_Solid );
    SetCullMode( CullMode_Back );
    SetFrontFace( FrontFace_Ccw );
    SetPrimitiveTopologyType( PrimitiveTopologyType_Triangle );
    SetRasterEnabled( true );
    SetMultisampleEnabled( false );
    SetDepthClipEnabled( true );
    SetScissorEnabled( false );
    SetDepthBias( 0 );
    SetDepthBiasClamp( 0.0f );
    SetSlopeScaledDepthBias( 0.0f );
    SetConservativeRasterizationMode( ConservativeRasterizationMode_Disable );
    EditMultisampleStateInfo().SetDefault();
}

void BlendTargetStateInfo::SetDefault() NN_NOEXCEPT
{
    SetBlendEnabled( false );
    SetSourceColorBlendFactor( BlendFactor_One );
    SetDestinationColorBlendFactor( BlendFactor_Zero );
    SetColorBlendFunction( BlendFunction_Add );
    SetSourceAlphaBlendFactor( BlendFactor_One );
    SetDestinationAlphaBlendFactor( BlendFactor_Zero );
    SetAlphaBlendFunction( BlendFunction_Add );
    SetChannelMask( ChannelMask_All );
}

void BlendStateInfo::SetDefault() NN_NOEXCEPT
{
    SetAlphaToCoverageEnabled( false );
    SetDualSourceBlendEnabled( false );
    SetIndependentBlendEnabled( false );
    SetLogicOperationEnabled( false );
    SetLogicOperation( LogicOperation_NoOp );
    SetBlendConstant( 0.0f, 0.0f, 0.0f, 1.0f );
    SetBlendTargetStateInfoArray( NULL, 0 );
}

void StencilStateInfo::SetDefault() NN_NOEXCEPT
{
    SetStencilFailOperation( StencilOperation_Keep );
    SetDepthFailOperation( StencilOperation_Keep );
    SetDepthPassOperation( StencilOperation_Keep );
    SetComparisonFunction( ComparisonFunction_Always );
    SetStencilRef( 0 );
}

void DepthStencilStateInfo::SetDefault() NN_NOEXCEPT
{
    SetDepthComparisonFunction( ComparisonFunction_Less );
    SetDepthTestEnabled( false );
    SetDepthWriteEnabled( false );
    SetStencilTestEnabled( false );
    SetDepthBoundsTestEnabled( false );
    SetStencilReadMask( static_cast< uint8_t >( ~0 ) );
    SetStencilWriteMask( static_cast< uint8_t >( ~0 ) );
    EditFrontStencilStateInfo().SetDefault();
    EditBackStencilStateInfo().SetDefault();
}

void ColorTargetStateInfo::SetDefault() NN_NOEXCEPT
{
    SetFormat( ImageFormat_Undefined );
}

void RenderTargetStateInfo::SetDefault() NN_NOEXCEPT
{
    SetDepthStencilFormat( ImageFormat_Undefined );
    SetColorTargetStateInfoArray( NULL, 0 );
}

void VertexAttributeStateInfo::SetDefault() NN_NOEXCEPT
{
    SetSemanticIndex( 0 );
    SetShaderSlot( -1 );
    SetBufferIndex( 0 );
    SetOffset( 0 );
    SetFormat( AttributeFormat_Undefined );
    SetNamePtr( NULL );
}

void VertexBufferStateInfo::SetDefault() NN_NOEXCEPT
{
    SetStride( 0 );
    SetDivisor( 0 );
}

void VertexStateInfo::SetDefault() NN_NOEXCEPT
{
    SetVertexAttributeStateInfoArray( NULL, 0 );
    SetVertexBufferStateInfoArray( NULL, 0 );
}

void TessellationStateInfo::SetDefault() NN_NOEXCEPT
{
    SetPatchControlPointCount( 1 );
}

void ViewportStateInfo::SetDefault() NN_NOEXCEPT
{
    SetOriginX( 0.0f );
    SetOriginY( 0.0f );
    SetWidth( 0.0f );
    SetHeight( 0.0f );
    SetMinDepth( 0.0f );
    SetMaxDepth( 1.0f );
}

void ScissorStateInfo::SetDefault() NN_NOEXCEPT
{
    SetOriginX( 0 );
    SetOriginY( 0 );
    SetWidth( 0 );
    SetHeight( 0 );
}

void ViewportScissorStateInfo::SetDefault() NN_NOEXCEPT
{
    SetScissorEnabled( false );
    SetViewportStateInfoArray( NULL, 0 );
    SetScissorStateInfoArray( NULL, 0 );
}

NN_STATIC_ASSERT( sizeof( MultisampleStateInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( RasterizerStateInfoData ) == 64 );
NN_STATIC_ASSERT( sizeof( BlendTargetStateInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( BlendStateInfoData ) == 48 );
NN_STATIC_ASSERT( sizeof( StencilStateInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( DepthStencilStateInfoData ) == 64 );
NN_STATIC_ASSERT( sizeof( ColorTargetStateInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( RenderTargetStateInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( VertexAttributeStateInfoData ) == 40 );
NN_STATIC_ASSERT( sizeof( VertexBufferStateInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( VertexStateInfoData ) == 48 );
NN_STATIC_ASSERT( sizeof( DepthRangeInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( ViewportStateInfoData ) == 48 );
NN_STATIC_ASSERT( sizeof( ScissorStateInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( ViewportScissorStateInfoData ) == 32 );

}
}
