﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_RootSignatureInfo.h>

NN_PRAGMA_PUSH_WARNINGS
NN_DISABLE_WARNING_DEPRECATED_DECLARATIONS

namespace nn {
namespace gfx {

void DescriptorRangeInfo::SetDefault() NN_NOEXCEPT
{
    SetDescriptorSlotType( DescriptorSlotType_ConstantBuffer );
    SetDescriptorSlotCount( 0 );
    SetBaseShaderSlot( 0 );
    SetTextureSamplerDescriptorSlotOffset( 0, 0 );
}

void DescriptorTableInfo::SetDefault() NN_NOEXCEPT
{
    SetShaderStage( ShaderStage_Vertex );
    SetDescriptorRangeInfoArray( NULL, 0 );
}

void DynamicDescriptorInfo::SetDefault() NN_NOEXCEPT
{
    SetShaderSlot( 0 );
}

void RootSignatureInfo::SetDefault() NN_NOEXCEPT
{
    SetDescriptorTableInfoArray( NULL, 0 );
    SetDynamicDescriptorInfoArray( NULL, 0 );
}

NN_STATIC_ASSERT( sizeof( DescriptorRangeInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( DescriptorTableInfoData ) == 32 );
NN_STATIC_ASSERT( sizeof( DynamicDescriptorInfoData ) == 16 );
NN_STATIC_ASSERT( sizeof( RootSignatureInfoData ) == 64 );

}
}

NN_PRAGMA_POP_WARNINGS
