﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_Variation-api.vk.h>
#include <nn/gfx/gfx_ResShader.h>

#include <nn/gfx/detail/gfx_Shader-api.vk.1.h>

#include <nn/gfx/detail/gfx_ResShaderImpl.h>

#include "gfx_CommonHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationVk1 Target;

template<>
void ResShaderContainerImpl::Initialize< Target >( ResShaderContainer* pThis,
    detail::DeviceImpl< Target >* pDevice, detail::MemoryPoolImpl< Target >*, ptrdiff_t, size_t ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pDevice );
    NN_UNUSED( pDevice );

    ResShaderContainer::value_type& data = pThis->ToData();
    NN_SDK_ASSERT( CheckBinaryTarget( data, Target::Type::value, Target::Version::value ) );
    NN_UNUSED( data );

    for ( int idxVariation = 0, variationCount = pThis->GetShaderVariationCount();
        idxVariation < variationCount; ++idxVariation )
    {
        pThis->ToData().targetCodeType = ShaderCodeType_Ir;
        nn::gfx::ResShaderProgram* pIrProgram = pThis->GetResShaderProgram( idxVariation );

        pThis->ToData().targetCodeType = ShaderCodeType_Source;
        if (nn::gfx::ResShaderProgram* pSourceProgram = pThis->GetResShaderProgram(idxVariation))
        {
            pSourceProgram->ToData().pShaderReflection = pIrProgram->ToData().pShaderReflection;
            pSourceProgram->ToData().pShaderCompilerReflection = pIrProgram->ToData().pShaderCompilerReflection;
        }
    }

    pThis->ToData().targetCodeType = ShaderCodeType_Ir;
}

template<>
void ResShaderContainerImpl::Finalize< Target >(
    ResShaderContainer*, detail::DeviceImpl< Target >* pDevice ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pDevice );
    NN_UNUSED( pDevice );
}

}
}
}
