﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_HORIZON )
    #error
#endif

#include <nn/nn_SdkAssert.h>

#include "gfx_CommonHelper.h"
#include "gfx_NvnHelper.h"

namespace nn {
namespace gfx {
namespace detail {

GlslcDll::GlslcCompilePreSpecializedType GetGlslcCompilePreSpecializedFunction();
GlslcDll::GlslcCompileSpecializedType GetGlslcCompileSpecializedFunction();
GlslcDll::GlslcInitializeType GetGlslcInitializeFunction();
GlslcDll::GlslcFinalizeType GetGlslcFinalizeFunction();
GlslcDll::GlslcCompileType GetGlslcCompileFunction();
GlslcDll::GlslcGetVersionType GetGlslcGetVersionFunction();
GlslcDll::GlslcSetAllocatorType GetGlslcSetAllocatorFunction();
GlslcDll::GlslcGetDefaultOptionsType GetGlslcGetDefaultOptionsFunction();

int Nvn::GetFirstScanBufferIndex() NN_NOEXCEPT
{
    return 0;
}

void Nvn::SetPackagedTextureDataImpl( NVNtextureBuilder*, const TextureInfo&,
    MemoryPoolImpl< ApiVariationNvn8 >*, ptrdiff_t, size_t ) NN_NOEXCEPT
{
}

void Nvn::SetTextureViewFormat( NVNtextureView* pTextureView, NVNformat value,
    const NVNtexture* ) NN_NOEXCEPT
{
    NN_GFX_CALL_NVN_FUNCTION( nvnTextureViewSetFormat( pTextureView, value ) );
}

nn::TimeSpan Nvn::ToTimeSpan( int64_t timestamp ) NN_NOEXCEPT
{
    return nn::TimeSpan::FromNanoSeconds( ( timestamp * 13 ) >> 3 );
}

bool GlslcDll::Initialize() NN_NOEXCEPT
{
    this->GlslcCompilePreSpecialized = GetGlslcCompilePreSpecializedFunction();
    this->GlslcCompileSpecialized = GetGlslcCompileSpecializedFunction();
    this->GlslcInitialize = GetGlslcInitializeFunction();
    this->GlslcFinalize = GetGlslcFinalizeFunction();
    this->GlslcCompile = GetGlslcCompileFunction();
    this->GlslcGetVersion = GetGlslcGetVersionFunction();
    this->GlslcSetAllocator = GetGlslcSetAllocatorFunction();
    this->GlslcGetDefaultOptions = GetGlslcGetDefaultOptionsFunction();

    return this->GlslcCompilePreSpecialized && this->GlslcCompileSpecialized &&
        this->GlslcInitialize && this->GlslcFinalize && this->GlslcCompile &&
        this->GlslcGetVersion && this->GlslcSetAllocator && this->GlslcGetDefaultOptions;
}

void GlslcDll::Finalize() NN_NOEXCEPT
{
}

bool GlslcDll::IsInitialized() const NN_NOEXCEPT
{
    return this->GlslcCompilePreSpecialized != NULL;
}

bool IsThinBinaryAvailable() NN_NOEXCEPT
{
    return true;
}

}
}
}
