﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_MemoryPoolInfo.h>

#include <nn/gfx/detail/gfx_MemoryPool-api.gl.4.h>

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationGl4 Target;

size_t MemoryPoolImpl< Target >::GetPoolMemoryAlignment(
    DeviceImpl< Target >*, const InfoType& ) NN_NOEXCEPT
{
    return 1;
}

size_t MemoryPoolImpl< Target >::GetPoolMemorySizeGranularity(
    DeviceImpl< Target >*, const InfoType& ) NN_NOEXCEPT
{
    return 1;
}

MemoryPoolImpl< Target >::MemoryPoolImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

MemoryPoolImpl< Target >::~MemoryPoolImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void MemoryPoolImpl< Target >::Initialize( DeviceImpl< Target >*, const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_NotInitialized );

    NN_SDK_ASSERT( !this->pMemory );

    this->memoryPoolProperty = static_cast< Bit32 >( info.GetMemoryPoolProperty() );
    this->memorySize = static_cast< uint32_t >( info.GetPoolMemorySize() );
    this->pMemory = info.GetPoolMemory();

    this->state = State_Initialized;
}

void MemoryPoolImpl< Target >::Finalize( DeviceImpl< Target >* ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );

    this->pMemory = NULL;

    this->state = State_NotInitialized;
}

void* MemoryPoolImpl< Target >::Map() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );
    return this->pMemory;
}

void MemoryPoolImpl< Target >::Unmap() const NN_NOEXCEPT
{
}

void MemoryPoolImpl< Target >::FlushMappedRange( ptrdiff_t, size_t ) const NN_NOEXCEPT
{
}

void MemoryPoolImpl< Target >::InvalidateMappedRange( ptrdiff_t, size_t ) const NN_NOEXCEPT
{
}

}
}
}
