﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cafe/gx2.h>
#include <cafe/gx2ut.h>
#include <cafe/dmae.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/gfx/gfx_Enum.h>

#include <nn/gfx/detail/gfx_Common-api.gx.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

#define NN_GFX_CALL_GX_FUNCTION(func) (func)

namespace nn {
namespace gfx {
namespace detail {

// Special display functions that allow us to swap with GX2UT
extern "C" void GX2WaitForFreeScanBuffer(GX2ScanTarget target);
extern "C" void GX2GetCurrentScanBuffer(GX2ScanTarget target, GX2ColorBuffer *scanBuffer);
extern "C" void GX2MarkScanBufferCopied(GX2ScanTarget target);

struct DisplayInfo
{
    const char* name;
    union {
        detail::GxEnum tvScanMode;
        detail::GxEnum drcScanMode;
    };
    nn::Bit32 width;
    nn::Bit32 height;
    bool isTV;
    bool isEnabled;
};

extern DisplayInfo displays[ 2 ];

class Gx
{
public:
    static bool IsArrayTarget( GX2SurfaceDim dim ) NN_NOEXCEPT;
    static GX2StencilFunction GetStencilFunction( StencilOperation operation ) NN_NOEXCEPT;
    static GX2CompareFunction GetCompareFunction( ComparisonFunction function ) NN_NOEXCEPT;
    static GX2AttribFormat GetAttributeFormat( AttributeFormat attributeFormat ) NN_NOEXCEPT;
    static GX2PolygonMode GetPolygonMode( FillMode fillMode ) NN_NOEXCEPT;
    static GX2PrimitiveType GetPrimitiveType( PrimitiveTopology topology ) NN_NOEXCEPT;
    static GX2LogicOp GetLogicalOperation( LogicOperation logicOperation ) NN_NOEXCEPT;
    static GX2BlendFunction GetBlendFunction( BlendFactor blendFactor ) NN_NOEXCEPT;
    static GX2BlendCombine GetBlendCombineMode( BlendFunction blendFunction ) NN_NOEXCEPT;
    static GX2SurfaceDim GetSurfaceDimension( ImageDimension imageDimension ) NN_NOEXCEPT;
    static GX2AAMode GetAaMode( int numberOfSamples ) NN_NOEXCEPT;
    static GX2Component GetComponentMapping( ChannelMapping mapping ) NN_NOEXCEPT;
    static GX2SurfaceFormat GetSurfaceFormat( ImageFormat format ) NN_NOEXCEPT;
    static GX2IndexFormat GetIndexFormat( IndexFormat indexFormat ) NN_NOEXCEPT;
    static GX2TexBorderType GetTextureBorderType( TextureBorderColorType borderColorTabe ) NN_NOEXCEPT;
    static GX2TexClamp GetTextureClamp( TextureAddressMode textureAddressMode ) NN_NOEXCEPT;
    static void SetSwapInterval( int swapInterval ) NN_NOEXCEPT;
    static GX2BufferingMode GetBufferingMode( int bufferCount ) NN_NOEXCEPT;

    static void GetImageFormatProperty( ImageFormatProperty* pOutImageFormatProperty,
        GX2SurfaceFormat gx2SurfaceFormat ) NN_NOEXCEPT;

    static const int MaxCoreCount = 3;
    static GX2DisplayListOverrun g_DisplayListOverrun;
    static CommandBufferImpl< ApiVariationGx2 >* g_pCurrentCommandBuffer[ MaxCoreCount ];
    static void CallbackFunction( GX2CallbackEvent callbackEvent, void* pUserData ) NN_NOEXCEPT;
};

struct DisplayList
{
    uint32_t bufferSize;
    uint32_t usedSize;
    union
    {
        detail::Ptr< void > pBuffer; // bufferSize != 0
        detail::Ptr< void > pNextDisplayList; // bufferSize == 0
    };
};

template< typename TObject >
inline bool IsInitialized( const TObject& obj ) NN_NOEXCEPT
{
    return obj.ToData()->state == TObject::DataType::State_Initialized;
}

}
}
}
