﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_WIN32 )
    #error
#endif

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Windows.h>

#include <nn/os/os_MutexApi.h>

#include <nn/gfx/detail/gfx_Device-api.gl.4-os.win32.h>
#include <nn/gfx/detail/gfx_SwapChain-api.gl.4-os.win32.h>
#include <nn/gfx/detail/gfx_Queue-api.gl.4.h>

#include "gfx_CommonHelper.h"
#include "gfx_GlHelper.h"
#include "gfx_WglHelper.h"

namespace nn {
namespace gfx {
namespace detail {

void Gl::PolygonMode( GLenum face, GLenum mode ) NN_NOEXCEPT
{
    NN_GFX_CALL_GL_FUNCTION( glPolygonMode( face, mode ) );
}

void Gl::LogicOp( GLenum opcode ) NN_NOEXCEPT
{
    NN_GFX_CALL_GL_FUNCTION( glLogicOp( opcode ) );
}

void Gl::GetSurfaceSize( int* pOutWidth, int* pOutHeight,
    SwapChainImpl< ApiVariationGl4 >* pSwapChain ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pOutWidth );
    NN_SDK_ASSERT_NOT_NULL( pOutHeight );
    NN_SDK_ASSERT_NOT_NULL( pSwapChain );

    RECT rect;
    GetClientRect( pSwapChain->ToData()->hWnd, &rect );
    *pOutWidth = static_cast< int >( rect.right );
    *pOutHeight = static_cast< int >( rect.bottom );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    DeviceImpl< ApiVariationGl4 >* pTarget, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pTarget );

    DeviceImpl< ApiVariationGl4 >::DataType& data = pTarget->ToData();
    Activate( data.hDc, &data.renderingContext, overwrite );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    QueueImpl< ApiVariationGl4 >* pTarget, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pTarget );

    QueueImpl< ApiVariationGl4 >::DataType& data = pTarget->ToData();
    Activate( data.hDc, &data.renderingContext, overwrite );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    SwapChainImpl< ApiVariationGl4 >* pSwapChain,
    GlRenderingContext* pRenderingContext, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pSwapChain );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext );

    SwapChainImpl< ApiVariationGl4 >::DataType& data = pSwapChain->ToData();
    Activate( data.hDc, pRenderingContext, overwrite );
}

void GlDeviceActivator::Activate( void* hDc,
    GlRenderingContext* pRenderingContext, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( hDc );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext->hGlRc );

    m_pMutex = NULL;
    m_Wgl.hDc = ::wglGetCurrentDC();
    m_Wgl.hGlRc = ::wglGetCurrentContext();
    if( m_Wgl.hGlRc == NULL || m_Wgl.hDc != static_cast< HDC >( hDc ) ||
        ( overwrite && m_Wgl.hGlRc != pRenderingContext->hGlRc ) )
    {
        m_pMutex = &pRenderingContext->mutex;
        NN_GFX_CALL_NNOS_FUNCTION( nn::os::LockMutex( m_pMutex ) );
        Wgl::MakeCurrent( static_cast< HDC >( hDc ), static_cast< HGLRC >( pRenderingContext->hGlRc ) );
    }
}

GlDeviceActivator::~GlDeviceActivator() NN_NOEXCEPT
{
    if( m_pMutex )
    {
        BOOL result = ::wglMakeCurrent( static_cast< HDC >( m_Wgl.hDc ), static_cast< HGLRC >( m_Wgl.hGlRc ) );
        NN_SDK_ASSERT( result == TRUE, "GetLastError: 0x%08X\n", GetLastError() );
        NN_UNUSED( result );
        NN_GFX_CALL_NNOS_FUNCTION( nn::os::UnlockMutex( m_pMutex ) );
        m_pMutex = NULL;
        m_Wgl.hGlRc = NULL;
        m_Wgl.hDc = NULL;
    }
}

}
}
}
