﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <EGL/egl.h>

#include <nn/nn_Macro.h>

#define NN_GFX_CALL_EGL_FUNCTION( func ) (func)

#if defined( NN_SDK_BUILD_DEBUG )
#define NN_GFX_EGL_ASSERT() \
    do \
    { \
        EGLint error; NN_UNUSED( error ); \
        NN_SDK_ASSERT( EGL_SUCCESS == ( error = ::eglGetError() ), "EGL Error: %s (0x%08X)\n", \
            nn::gfx::detail::Egl::ErrorToString( error ), error ); \
    } while( NN_STATIC_CONDITION( 0 ) )
#else
    #define NN_GFX_EGL_ASSERT()
#endif

#define NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK( func ) \
    NN_GFX_CALL_EGL_FUNCTION( func ); \
    NN_GFX_EGL_ASSERT()

#define NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT( func ) \
    do \
    { \
        EGLBoolean NN_MACRO_CONCATENATE( eglResult, __LINE__ ) = EGLBoolean(); \
        NN_UNUSED( NN_MACRO_CONCATENATE( eglResult, __LINE__ ) ); \
        NN_GFX_CALL_EGL_FUNCTION( NN_MACRO_CONCATENATE( eglResult, __LINE__ ) = ( func ) ); \
        NN_GFX_EGL_ASSERT(); \
        NN_SDK_ASSERT_EQUAL( NN_MACRO_CONCATENATE( eglResult, __LINE__ ), EGL_TRUE ); \
    } \
    while( 0 )

namespace nn {
namespace gfx {
namespace detail {

class Egl
{
public:
    static const char* ErrorToString( EGLint error ) NN_NOEXCEPT;

    static void MakeCurrent( EGLDisplay dpy,
        EGLSurface darw, EGLSurface read, EGLContext ctx ) NN_NOEXCEPT;

    static EGLConfig GetConfig( EGLDisplay dpy, EGLContext ctx ) NN_NOEXCEPT;

    static EGLConfig GetConfig( EGLDisplay dpy ) NN_NOEXCEPT;

    static EGLContext CreateGlRc( EGLDisplay dpy, EGLConfig config,
        EGLContext sharedRc, int majorVersion, int minorVersion ) NN_NOEXCEPT;
};

}
}
}
