﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_COS )
    #error
#endif

#include <nn/nn_SdkAssert.h>

#include <nn/gfx/gfx_DeviceInfo.h>
#include <nn/gfx/detail/gfx_Core-api.gx.2.h>
#include <nn/gfx/detail/gfx_Device-api.gx.2-os.cos.h>

#include "gfx_GxHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationGx2 Target;

DeviceImpl< Target >::DeviceImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

DeviceImpl< Target >::~DeviceImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void DeviceImpl< Target >::Initialize( const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_NotInitialized );

    if( info.GetDebugMode() == DebugMode_Enable )
    {
        NN_GFX_CALL_GX_FUNCTION( GX2SetDebugMode( static_cast< GX2DebugMode >(
            GX2_DEBUG_MODE_FLUSH_PER_DRAW | GX2_DEBUG_MODE_DONE_PER_FLUSH ) ) );
    }

    this->state = State_Initialized;
}

void DeviceImpl< Target >::Finalize() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );

    this->state = State_NotInitialized;
}

}
}
}
