﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_WIN32 )
#error
#endif

#include <nn/nn_SdkAssert.h>

#include <nn/os/os_MutexApi.h>

#include <nn/hws/hws_Window.h>
#include <nn/vi/vi_Layer.h>

#include <nn/gfx/gfx_DeviceInfo.h>

#include <nn/gfx/detail/gfx_Device-api.gl.4-os.win32.h>

#include "gfx_CommonHelper.h"
#include "gfx_GlHelper.h"
#include "gfx_WGLHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationGl4 Target;

DeviceImpl< Target >::DeviceImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

DeviceImpl< Target >::~DeviceImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized || this->flags.GetBit( Flag_Shared ) );

    if( this->flags.GetBit( Flag_Shared ) )
    {
        if( this->hDc )
        {
            ::ReleaseDC( this->hWnd, this->hDc );
            this->hDc = NULL;
        }
        NN_GFX_CALL_NNOS_FUNCTION( nn::os::FinalizeMutex( &this->renderingContext.mutex ) );
    }
}

void DeviceImpl< Target >::Initialize( const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_UNUSED( info );

    this->hWnd = nn::hws::FindWindow( "GfxSystemDisplay" ).Get();
    NN_SDK_ASSERT_NOT_NULL( this->hWnd );

    this->hDc = ::GetDC( static_cast< HWND >( this->hWnd ) );
    NN_SDK_ASSERT_NOT_NULL( this->hDc );

    NN_SDK_ASSERT( this->renderingContext.hGlRc == NULL );
    this->renderingContext.hGlRc = Wgl::CreateGlRc( static_cast< HDC >( this->hDc ),
        NULL, GlRequiredVersionMajor, GlRequiredVersionMinor, info.GetDebugMode() != DebugMode_Disable );
    NN_SDK_ASSERT_NOT_NULL( this->renderingContext.hGlRc );
    NN_GFX_CALL_NNOS_FUNCTION( nn::os::InitializeMutex(
        &this->renderingContext.mutex, true, nn::os::MutexLockLevelMax ) );

    Gl::InitializeDeviceCommonImpl( this, info );

    this->flags.SetBit( Flag_Shared, false );
    this->state = State_Initialized;
}

void DeviceImpl< Target >::Finalize() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );
    NN_SDK_ASSERT( !this->flags.GetBit( Flag_Shared ) );

    ::wglMakeCurrent( NULL, NULL );

    if( this->renderingContext.hGlRc )
    {
        Wgl::DeleteGlRc( static_cast< HGLRC >( this->renderingContext.hGlRc ) );
        this->renderingContext.hGlRc = NULL;
    }
    NN_GFX_CALL_NNOS_FUNCTION( nn::os::FinalizeMutex( &this->renderingContext.mutex ) );
    if( this->hDc )
    {
        ::ReleaseDC( static_cast< HWND >( this->hWnd ), static_cast< HDC >( this->hDc ) );
        this->hDc = NULL;
    }
    this->hWnd = NULL;

    this->state = State_NotInitialized;
}

}
}
}
