﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_WIN32 )
#error
#endif

#include <nn/nn_SdkAssert.h>

#include <nn/os/os_MutexApi.h>

#include <nn/hws/hws_Window.h>
#include <nn/vi/vi_Layer.h>

#include <nn/gfx/gfx_DeviceInfo.h>

#include <nn/gfx/detail/gfx_Device-api.d3d.11.h>

#include "gfx_CommonHelper.h"
#include "gfx_D3dHelper.h"
#include "gfx_WGLHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationD3d11 Target;

DeviceImpl< Target >::DeviceImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

DeviceImpl< Target >::~DeviceImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized || this->flags.GetBit( Flag_Shared ) );
}

void DeviceImpl< Target >::Initialize( const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_UNUSED( info );

    this->pWnd = nn::hws::FindWindow( "GfxSystemDisplay" ).Get();
    NN_SDK_ASSERT_NOT_NULL( this->pWnd );

    D3d::CreateDevice( reinterpret_cast< ID3D11Device** >( &this->renderingContext.hD3dDevice ),
        reinterpret_cast< ID3D11DeviceContext** >( &this->renderingContext.hD3dDeviceContext ), info.GetDebugMode() != DebugMode_Disable );

    this->maxColorAttachments = D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT;
    this->flags.SetBit( Flag_Shared, false );
    this->state = State_Initialized;
}

void DeviceImpl< Target >::Finalize() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );
    NN_SDK_ASSERT( !this->flags.GetBit( Flag_Shared ) );

    if( this->renderingContext.hD3dDevice )
    {
        D3d::DeleteDevice( static_cast< ID3D11Device* >( this->renderingContext.hD3dDevice ),
            static_cast< ID3D11DeviceContext* >( this->renderingContext.hD3dDeviceContext ) );
    }

    this->pWnd = NULL;

    this->state = State_NotInitialized;
}

}
}
}
