﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/ens_AsyncContext.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace ens {

AsyncContext::AsyncContext() NN_NOEXCEPT
    : m_TaskId(detail::InvalidTaskId)
    , m_CancelObserver(nullptr)
    , m_DestructObserver(nullptr)
    , m_Result(ResultInvalidState())
    , m_ErrorDetail(0)
    , m_Event(nn::os::EventClearMode_ManualClear)
{
}

AsyncContext::~AsyncContext() NN_NOEXCEPT
{
    if (m_DestructObserver)
    {
        m_DestructObserver(m_TaskId);
    }
}

nn::Result AsyncContext::GetResult() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_Event.TryWait());

    return m_Result;
}

int32_t AsyncContext::GetErrorDetail() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_Event.TryWait());

    return m_ErrorDetail;
}

void AsyncContext::Cancel() NN_NOEXCEPT
{
    if (m_CancelObserver)
    {
        m_CancelObserver(m_TaskId);
    }
}

nn::os::Event& AsyncContext::GetEvent() NN_NOEXCEPT
{
    return m_Event;
}

void AsyncContext::Register(const detail::TaskId& taskId,
    detail::CancelObserver cancelObserver, detail::DestructObserver destructObserver) NN_NOEXCEPT
{
    m_TaskId = taskId;
    m_CancelObserver = cancelObserver;
    m_DestructObserver = destructObserver;
}

void AsyncContext::Complete(nn::Result result) NN_NOEXCEPT
{
    Complete(result, 0);
}

void AsyncContext::Complete(nn::Result result, int32_t errorDetail) NN_NOEXCEPT
{
    m_Result = result;
    m_ErrorDetail = errorDetail;

    m_Event.Signal();
}

}}
