﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/util/rapidjson/ens_RapidJsonMemoryInputStream.h>
#include <algorithm>

namespace nn { namespace ens { namespace detail { namespace util { namespace rapidjson {

RapidJsonMemoryInputStream::RapidJsonMemoryInputStream() NN_NOEXCEPT
    : m_pData(nullptr)
    , m_Size(0)
    , m_Position(0)
    , m_IsOpened(false)
{
}

RapidJsonMemoryInputStream::~RapidJsonMemoryInputStream() NN_NOEXCEPT
{
}

void RapidJsonMemoryInputStream::Open(const void* pData, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pData);
    NN_SDK_REQUIRES_GREATER(size, 0u);

    NN_SDK_ASSERT(!m_IsOpened);

    m_pData = reinterpret_cast<const nn::Bit8*>(pData);
    m_Size = size;

    m_Position = 0;

    m_IsOpened = true;
}

void RapidJsonMemoryInputStream::Close() NN_NOEXCEPT
{
    m_IsOpened = false;
}

nn::Result RapidJsonMemoryInputStream::FillImpl(size_t* pOutRead, void* pOutData, size_t dataSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsOpened);

    size_t remainSize = m_Size - m_Position;

    if (remainSize == 0)
    {
        *pOutRead = 0;
        NN_RESULT_SUCCESS;
    }

    size_t readSize = std::min(dataSize, remainSize);

    std::memcpy(pOutData, &m_pData[m_Position], readSize);
    m_Position += readSize;

    *pOutRead = readSize;

    NN_RESULT_SUCCESS;
}

}}}}}
