﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/util/ens_ServiceErrorHandler.h>

namespace nn { namespace ens { namespace detail { namespace util {

nn::Result HandleServiceError(int code) NN_NOEXCEPT
{
    switch (code)
    {
    case 3001:
        return ResultMissingRequiredParameter();
    case 3002:
        return ResultInvalidParameter();
    case 3003:
        return ResultForbidden();
    case 3004:
        return ResultRoutingError();
    case 3005:
        return ResultNotFound();
    case 3101:
        return ResultUniqueIdGenerationFailed();
    case 4001:
        return ResultNetworkServiceAccountIdTokenVerificationFailed();
    case 4002:
        return ResultNetworkServiceAccountIdTokenExpired();
    case 4101:
        return ResultAuthTokenVerificationFailed();
    case 4102:
        return ResultAuthTokenExpired();
    case 4201:
        return ResultWrongCredentials();
    default:
        return ResultUnexpectedServiceError();
    }
}

}}}}
