﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/util/ens_MessagePackMemoryInputStream.h>

namespace nn { namespace ens { namespace detail { namespace util {

MessagePackMemoryInputStream::MessagePackMemoryInputStream() NN_NOEXCEPT
    : m_pData(nullptr)
    , m_Size(0)
    , m_Position(0)
{
}

MessagePackMemoryInputStream::~MessagePackMemoryInputStream() NN_NOEXCEPT
{
}

void MessagePackMemoryInputStream::Open(const void* pData, size_t size) NN_NOEXCEPT
{
    m_pData = reinterpret_cast<const nn::Bit8*>(pData);
    m_Size = size;

    m_Position = 0;
}

void MessagePackMemoryInputStream::Close() NN_NOEXCEPT
{
    m_pData = nullptr;
    m_Size = 0;
}

bool MessagePackMemoryInputStream::Read(void* pBuffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_GREATER(size, 0u);

    size_t remainSize = m_Size - m_Position;

    if (remainSize < size)
    {
        return false;
    }

    std::memcpy(pBuffer, &m_pData[m_Position], size);
    m_Position += size;

    return true;
}

bool MessagePackMemoryInputStream::GetDataPointerFromMemoryCache(const void** ppOutData, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(ppOutData);
    NN_SDK_REQUIRES_GREATER(size, 0u);

    size_t remainSize = m_Size - m_Position;

    if (remainSize < size)
    {
        return false;
    }

    *ppOutData = &m_pData[m_Position];
    m_Position += size;

    return true;
}

}}}}
