﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/core/ens_Url.h>
#include <cstdarg>

namespace nn { namespace ens { namespace detail { namespace core {

namespace
{
    nn::os::SdkMutex g_Mutex;

    const char* g_pServerKey = "";
}

void SetServerKey(const char* pServerKey) NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Mutex);

    g_pServerKey = pServerKey;
}

void MakeUrl(char* pOutUrl, size_t size, const char* pModule, const char* pPath, ...) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pModule);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    {
        NN_UTIL_LOCK_GUARD(g_Mutex);

#if defined(NN_BUILD_CONFIG_OS_WIN32)

        // テストサーバーは PC 上に構築する。
        int offset = nn::util::SNPrintf(pOutUrl, size, "http://localhost:4567");

#elif defined(NN_BUILD_CONFIG_OS_HORIZON)

        int offset = nn::util::SNPrintf(pOutUrl, size, "https://%s.hac.%%.%s.srv.nintendo.net", pModule, g_pServerKey);

#endif

        NN_ABORT_UNLESS_LESS(static_cast<size_t>(offset), size);

        pOutUrl += offset;
        size -= offset;
    }

    std::va_list args;

    va_start(args, pPath);

    NN_ABORT_UNLESS_LESS(static_cast<size_t>(nn::util::VSNPrintf(pOutUrl, size, pPath, args)), size);

    va_end(args);
}

}}}}
