﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/app/acbaa/task/ens_TaskDeleteMyDesign.h>
#include <nn/ens/detail/core/ens_HttpRequestHeader.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

TaskDeleteMyDesign::TaskDeleteMyDesign() NN_NOEXCEPT
    : m_MyDesignId(InvalidMyDesignId)
{
}

TaskDeleteMyDesign::~TaskDeleteMyDesign() NN_NOEXCEPT
{
}

void TaskDeleteMyDesign::SetParameter(const MyDesignId& myDesignId) NN_NOEXCEPT
{
    m_MyDesignId = myDesignId;
}

nn::Result TaskDeleteMyDesign::ExecuteSteps() NN_NOEXCEPT
{
    NN_RESULT_DO(StepDelete());

    NN_RESULT_SUCCESS;
}

nn::Result TaskDeleteMyDesign::StepDelete() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/designs/%llu", m_MyDesignId.value);

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "DELETE"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    detail::core::HttpRequestHeader header;

    NN_RESULT_DO(header.Add("Authorization", "Bearer %s", GetAuthToken().value));
    NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_RESULT_SUCCESS;
}

}}}}}
