﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/eft/eftvw2_Function.h>
#include <nw/eft/eftvw2_Preview.h>


//------------------------------------------------------------------------------
namespace nw {
namespace eftvw2 {


//---------------------------------------------------------------------------
//! @brief        コンストラクタです。
//---------------------------------------------------------------------------
Function::Function()
{
    // TODO:後で考える
    // mEftHeap            = NULL;
    // mPreview            = NULL;
    // mFunctionParam      = NULL;
    //
    // mAutoMoveRadius     = 8.0f;
    // mAutoMoveRot	    = 0;
    // mAutoMoveRotVel     = ( 0xffffffff / 360 );
    // nw::math::MTX34Identity( &mAutoMoveMtx );
    // mAutoYSwingRot      = 0;
    // mAutoYSwingSpeed    = ( 0xffffffff / 360 * 5 );
    // mAutoYSwing         = 0;
    // mAutoMoveOldPos.Set( 0.0f, 0.0f, 0.0f );
    // mAutoZRollSpeed     = 0;
    // mAutoZRoll		    = 0;
}


//---------------------------------------------------------------------------
//! @brief        初期化処理です。
//---------------------------------------------------------------------------
void Function::Initialize( nw::eft2::Heap* eftHeap, Preview* preview )
{
    mPreview        = preview;
    mEftHeap        = eftHeap;
}


//---------------------------------------------------------------------------
//! @brief        終了処理です。
//---------------------------------------------------------------------------
void Function::Finalize()
{
    // TODO:後で考える
    //if( mFunctionParam )
    //{
    //    mEftHeap->Free( mFunctionParam );
    //}
}


//---------------------------------------------------------------------------
//! @brief        パラメータをセットします。
//---------------------------------------------------------------------------
void Function::SetFunctionParam( void* header, u32 size )
{
    EFT_UNUSED_VARIABLE( header );
    EFT_UNUSED_VARIABLE( size );
    // TODO:後で考える
    // if( mFunctionParam )
    // {
    //     mEftHeap->Free( mFunctionParam );
    // }
    //
    // // 内部にワークを確保して
    // // ファンクションパラメータをコピーします。
    // mFunctionParam = (EftFuncParamHeader *)mEftHeap->Alloc( size );
    // EFT_ASSERT( mFunctionParam );
    //
    // memcpy( mFunctionParam, header, size );
}


//---------------------------------------------------------------------------
//! @brief        指定IDのファンクションを保持するか？
//---------------------------------------------------------------------------
bool Function::HasFunction( u32 functionId )
{
    EFT_UNUSED_VARIABLE( functionId );
    // TODO:後で考える
    //if( !mFunctionParam ) return false;
    //
    //EftFuncParamHeader* current = mFunctionParam;
    //
    //while( current )
    //{
    //    if ( current->functionId == functionId )
    //    {
    //        return true;
    //    }
    //
    //    if ( current->offset == 0 ) break;
    //    current = (EftFuncParamHeader *)( (u8 *)current + current->offset );
    //}

    return false;
}


//---------------------------------------------------------------------------
//! @brief        計算処理です。
//---------------------------------------------------------------------------
void Function::Calc( const nw::math::Matrix34& view )
{
    EFT_UNUSED_VARIABLE( view );

    // TODO:後で考える
    //if( !mFunctionParam ) return;
    //
    //EftFuncParamHeader* current = mFunctionParam;
    //
    //// フレーム単位の初期化
    //nw::math::MTX34 drawMatrix;
    //nw::math::MTX34Identity( &drawMatrix );
    //
    //bool emitterBillboard = false;
    //
    //nw::math::VEC3 scale;
    //scale.x = 1.0f;
    //scale.y = 1.0f;
    //scale.z = 1.0f;
    //
    //// ファンクション登録数だけ実行する
    //while( current )
    //{
    //    // コンストレイン
    //    switch( current->functionId )
    //    {
    //
    //    case EFT_VWR_FUNC_CONSTRAINBONE:
    //    {
    //        // コンストレインパラメータへ移動
    //        EftFuncParamConstrain* constrain = (EftFuncParamConstrain *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //
    //        // コンストレイン先プレビュー
    //        Preview* model = NULL;
    //        const char *modelName = constrain->ModelName.Value;
    //
    //        if ( modelName && strlen( modelName ) != 0 )
    //        {
    //            model = mPreview->GetPreview( modelName, constrain->ModelIndex );
    //        }
    //
    //        nw::math::MTX34 boneMatrix;
    //
    //        if ( model && constrain->BoneNum != -1 ) {
    //            // 親モデルのマトリクスを取得します
    //            model->GetMatrix( &boneMatrix, constrain->BoneNum );
    //
    //            // コンストレインモードをONに
    //            mPreview->SetConstrainMode( true );
    //        }
    //        else {
    //            boneMatrix = nw::math::MTX34::Identity();
    //
    //            // コンストレインモードをOFFに
    //            mPreview->SetConstrainMode( false );
    //        }
    //
    //        // エミッタビルボードかどうか
    //        if ( constrain->EmitterBillboard )
    //        {
    //            emitterBillboard = true;
    //
    //            // エミッタビルボード用にスケールを保持
    //            scale.x = constrain->OffsetScale.x;
    //            scale.y = constrain->OffsetScale.y;
    //            scale.z = constrain->OffsetScale.z;
    //
    //            // TRS モードのみモデルスケールを適用
    //            if (constrain->MtxApplyMode == 0) {
    //                scale.x *= sqrtf( boneMatrix.m[0][0] * boneMatrix.m[0][0] + boneMatrix.m[0][1] * boneMatrix.m[0][1] + boneMatrix.m[0][2] * boneMatrix.m[0][2] );
    //                scale.y *= sqrtf( boneMatrix.m[1][0] * boneMatrix.m[1][0] + boneMatrix.m[1][1] * boneMatrix.m[1][1] + boneMatrix.m[1][2] * boneMatrix.m[1][2] );
    //                scale.z *= sqrtf( boneMatrix.m[2][0] * boneMatrix.m[2][0] + boneMatrix.m[2][1] * boneMatrix.m[2][1] + boneMatrix.m[2][2] * boneMatrix.m[2][2] );
    //            }
    //        }
    //
    //        // 行列の適応モード
    //        nw::math::MTX34 srt;
    //        if (constrain->MtxApplyMode == 0)
    //        {
    //            // TRS モード
    //            if ( !emitterBillboard )
    //            {
    //                nw::math::VEC3 rot;
    //                rot.x = constrain->OffsetRotateX;
    //                rot.y = constrain->OffsetRotateY;
    //                rot.z = constrain->OffsetRotateZ;
    //                nw::math::MTX34MakeSRT(&srt, &constrain->OffsetScale, &rot, &constrain->OffsetPosition);
    //            }
    //            else
    //            {
    //                nw::math::MTX34MakeST(&srt, &constrain->OffsetScale, &constrain->OffsetPosition);
    //            }
    //
    //            _MTX34Mult( &boneMatrix, &boneMatrix, &srt );
    //        } else {
    //            // T のみ
    //            nw::math::VEC3 pos;
    //            pos.x = boneMatrix._03;
    //            pos.y = boneMatrix._13;
    //            pos.z = boneMatrix._23;
    //            boneMatrix.SetIdentity();
    //            boneMatrix.SetTranslate( pos );
    //
    //            if ( !emitterBillboard )
    //            {
    //                nw::math::VEC3 rot;
    //                rot.x = constrain->OffsetRotateX;
    //                rot.y = constrain->OffsetRotateY;
    //                rot.z = constrain->OffsetRotateZ;
    //                nw::math::MTX34MakeSRT(&srt, &constrain->OffsetScale, &rot, &constrain->OffsetPosition);
    //            }
    //            else
    //            {
    //                nw::math::MTX34MakeST(&srt, &constrain->OffsetScale, &constrain->OffsetPosition);
    //            }
    //
    //            _MTX34Mult( &boneMatrix, &boneMatrix, &srt );
    //        }
    //
    //        // マトリクスを設定
    //        drawMatrix = boneMatrix;
    //    }
    //    break;
    //
    //
    //    // カラー
    //    case EFT_VWR_FUNC_COLOR:
    //    {
    //        // カラーパラメータへ移動
    //        EftFuncParamColor* color = (EftFuncParamColor *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //        mPreview->SetColor( &color->color );
    //    }
    //    break;
    //
    //    // エフェクト：トランスフォーム
    //    // TODO : EFT_VWR_FUNC_MODEL_TRANSFORMと統合させる。
    //    case EFT_VWR_FUNC_TRANSFORM:
    //    {
    //        // カラーパラメータへ移動
    //        EftFunctionTransform* params = (EftFunctionTransform *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //
    //        // プレビューのトランスフォームメソッド呼び出し
    //        mPreview->SetTransform(
    //            params->scale, params->rotate.x, params->rotate.y, params->rotate.z, params->position );
    //    }
    //    break;
    //
    //    // プレビュー：パーティクルスケール
    //    case EFT_VWR_FUNC_PARTICLE_SCALE:
    //    {
    //        EftFuncParamParticleScale* scale = (EftFuncParamParticleScale *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //        mPreview->SetParticleScale( &scale->particleScale, &scale->emissionScale );
    //        mPreview->SetEmitterScale( &scale->emitterScale );
    //    }
    //    break;
    //
    //    // パーティクル制御
    //    case EFT_VWR_FUNC_PARTICLE_VEL:
    //    {
    //        EftFuncParamParticleCtrl* ctrl = (EftFuncParamParticleCtrl *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //
    //        // ライフスケール
    //        mPreview->SetParticleLifeScale( ctrl->lifeScale );
    //
    //        // 初速
    //        mPreview->SetParticleVelocityScale( ctrl->allDirectionalVecScale, ctrl->directionalVecScale );
    //
    //        // 速度
    //        mPreview->SetParticleAddWorldVelocity( &ctrl->setAddVec );
    //
    //        // ランダム速度スケール
    //        mPreview->SetParticleRandomVelocity( ctrl->randomVelScale );
    //
    //        // 指定方向速度スケール
    //        //mPreview->SetParticleDirectionalVel( ctrl->dirVelScale );
    //
    //        // エミッタカラー
    //        if ( ctrl->enableEmitterColor != false )
    //        {
    //            mPreview->SetParticleEmitterColor0( &ctrl->emitterColor0 );
    //            mPreview->SetParticleEmitterColor1( &ctrl->emitterColor1 );
    //        }
#if 0
            // グローバル乗算カラーが反映されなくなってしまうため，一時的に無効化します.
            // 無効化により，プレビューノード>パーティクル制御タブのEnableを切り替えても設定した色が反映されたままになる不具合が再発します
            //else
            //{
            //    nw::ut::Color4f color( 1.0f, 1.0f, 1.0f, 1.0f );
            //    mPreview->SetParticleEmitterColor0( &color );
            //    mPreview->SetParticleEmitterColor1( &color );
            //}
#endif
    //     }
    //     break;
    //
    //     // パーティクル放出
    //     case EFT_VWR_FUNC_PARTICLE_EMIT:
    //     {
    //         EftFuncParamParticleEmission* emit = (EftFuncParamParticleEmission *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //         mPreview->SetParticleEmissionScale( emit->emissionRate, emit->EmissionInterval );
    //     }
    //     break;
    //
    //     // プレビュー：自動移動
    //     case EFT_VWR_FUNC_AUTO_TRANSFORM:
    //         {
    //             // パーティクルスケールパラメータへ移動
    //             EftFuncParamAutomaticTransform* automtic =
    //                     (EftFuncParamAutomaticTransform *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //             if ( automtic->autoMoveType == 0 )
    //             {
    //                 mAutoMoveRadius = 8.0f;
    //                 mAutoMoveRot	= 0;
    //                 mAutoMoveRotVel = ( 0xffffffff / 360 );
    //                 mAutoMoveMtx.SetIdentity();
    //                 mAutoYSwingRot  = 0;
    //                 mAutoYSwingSpeed  = ( 0xffffffff / 360 * 5 );
    //                 mAutoYSwing     = 0;
    //                 mAutoMoveOldPos.Set( 0.0f, 0.0f, 0.0f );
    //                 mAutoZRollSpeed = 0;
    //                 mAutoZRoll		= 0;
    //                 break;
    //             }
    //
    //             // パラメータを取得
    //             mAutoMoveRadius     = automtic->autoMoveRadius;
    //             mAutoMoveRotVel     = DegToIdx( automtic->autoMoveRotVel );
    //             mAutoYSwing         = automtic->autoYSwing;
    //             mAutoYSwingSpeed    = DegToIdx( automtic->autoYSwingSpeed );
    //             mAutoZRollSpeed     = DegToIdx( automtic->autoZRollSpeed );
    //
    //             // 使用するマトリクスを初期化
    //             nw::math::Matrix34 matAutoMove;
    //             matAutoMove.SetIdentity();
    //             nw::math::Matrix34 matRot;
    //             matRot.SetIdentity();
    //             nw::math::Matrix34 matZRoll;
    //             matZRoll.SetIdentity();
    //
    //             mAutoMoveMtx.SetIdentity();
    //
    //             // 更新
    //             mAutoMoveRot   += mAutoMoveRotVel;
    //             mAutoYSwingRot += mAutoYSwingSpeed;
    //
    //             if ( mAutoZRollSpeed != 0 )
    //             {
    //                 mAutoZRoll += mAutoZRollSpeed;
    //             }
    //             else
    //             {
    //                 mAutoZRoll = 0;
    //             }
    //
    //             // XZ移動
    //             nw::math::VEC3 pos;
    //             f32 sinV, cosV;
    //             nw::math::SinCosIdx( &sinV, &cosV, mAutoMoveRot );
    //             pos.x = sinV * mAutoMoveRadius;
    //             pos.z = cosV * mAutoMoveRadius;
    //
    //             // Y移動
    //             pos.y = nw::math::SinIdx( mAutoYSwingRot ) * mAutoYSwing;
    //
    //             // 回転行列作成
    //             //if( !mAutoMoveOldPos.IsZero() )
    //             {
    //                 nw::math::VEC3 basisZ = pos - mAutoMoveOldPos;
    //
    //                 if( basisZ.Length() > 0.00001f )
    //                 {
    //                     basisZ.Normalize();
    //
    //                     nw::math::VEC3 up( 0,1,0 );
    //                     nw::math::VEC3 basisX = up.Cross( basisZ );
    //
    //                     if( basisX.Length() > 0.00001f )
    //                     {
    //
    //                         basisX.Normalize();
    //
    //                         nw::math::VEC3 basisY;
    //                         basisY.SetCross( basisZ, basisX );
    //
    //                         matAutoMove.m[0][0] = basisX.x;
    //                         matAutoMove.m[1][0] = basisX.y;
    //                         matAutoMove.m[2][0] = basisX.z;
    //
    //                         matAutoMove.m[0][1] = basisY.x;
    //                         matAutoMove.m[1][1] = basisY.y;
    //                         matAutoMove.m[2][1] = basisY.z;
    //
    //                         matAutoMove.m[0][2] = basisZ.x;
    //                         matAutoMove.m[1][2] = basisZ.y;
    //                         matAutoMove.m[2][2] = basisZ.z;
    //
    //                         // ZRoll
    //                         matZRoll.SetRotate( nw::math::VEC3( 0.f, 0.f, 1.f ),  NW_MATH_IDX_TO_RAD( mAutoZRoll ) );
    //
    //                         // 合成
    //                         _MTX34Mult( &mAutoMoveMtx, &matAutoMove, &matZRoll );
    //                         mAutoMoveMtx.m[0][3] = pos.x;
    //                         mAutoMoveMtx.m[1][3] = pos.y;
    //                         mAutoMoveMtx.m[2][3] = pos.z;
    //                     }
    //                 }
    //             }
    //
    //             // マトリクスを更新
    //             _MTX34Mult( &drawMatrix, &drawMatrix, &mAutoMoveMtx );
    //
    //             // 現在の値を保存
    //             mAutoMoveOldPos = pos;
    //         }
    //         break;
    //
    //     // モデル：トランスフォーム
    //     case EFT_VWR_FUNC_MODEL_TRANSFORM:
    //     {
    //         EftFunctionTransform *params =
    //             (EftFunctionTransform*)( (u8 *)current + sizeof( EftFuncParamHeader ));
    //
    //         mPreview->SetTransform(
    // 	        params->scale, params->rotate.x, params->rotate.y, params->rotate.z, params->position );
    //     }
    //     break;
    //
    //     // モデル：アニメーション
    //     case EFT_VWR_FUNC_MODEL_ANIMATION:
    //     {
    //         EftFunctionAnimation *params =
    //             (EftFunctionAnimation*)( (u8 *)current + sizeof( EftFuncParamHeader ));
    //
    //         mPreview->SetAnimationSpeed( params->playSpeed );
    //         mPreview->SetAnimationIndex( params->animationIndex );
    //     }
    //     break;
    //
    //     // プレビュー：プレビューノード用
    //     case EFT_VWR_FUNC_GAMESETTING:
    //     {
    //         EftFuncParamDisplayPreview* display =
    // 		    (EftFuncParamDisplayPreview *)( (u8 *)current + sizeof( EftFuncParamHeader ) );
    //
    //         // TODO:モデルのみここでオンオフ
    //         if ( mPreview->GetPreviewType() == Preview::EFT_VWR_PRV_MODEL )
    //         {
    //             mPreview->SetVisible( display->displayPreview != 0 );
    //         }
    //     }
    //     break;
    //     }
    //
    //     // 次のヘッダへ移動
    //     if ( current->offset == 0 ) break;
    //     current = (EftFuncParamHeader *)( (u8 *)current + current->offset );
    // }
    //
    // // エミッタビルボードを適用する
    // if ( emitterBillboard )
    // {
    //     nw::math::MTX34 scaleMtx;
    //     scaleMtx.SetScale( scale );
    //
    //     nw::math::MTX34 srt( view );
    //     srt.Inverse();
    //     srt.m[0][3] = drawMatrix.m[0][3];
    //     srt.m[1][3] = drawMatrix.m[1][3];
    //     srt.m[2][3] = drawMatrix.m[2][3];
    //
    //     _MTX34Mult( &srt, &srt, &scaleMtx );
    //
    //     mPreview->SetMatrix( &srt );
    // }
    // else
    // {
    //     mPreview->SetMatrix( &drawMatrix );
    // }
}





//-----------------------------------------------------------------------------
} // namespace eftvw
} // namespace nw
