﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>

namespace nn{ namespace capsrv{ namespace server{

    class ScreenShotControlServiceImpl
    {
    public:
        nn::Result CaptureRawImageRgba32IntoArray(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index) NN_NOEXCEPT;
        nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result AttachSharedBufferToCaptureModule(nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT;
        nn::Result CaptureRawImageToAttachedSharedBuffer(std::int32_t dstIndex, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx2ViaAm(nn::sf::Out<ApplicationAlbumEntry> pOutEntry, nn::sf::InBuffer imageBuffer, const capsrv::detail::ScreenShotAttributeEx0& attribute, const UserIdList& userIdList, applet::AppletResourceUserId aruid, OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;

        nn::Result RequestTakingScreenShotEx1(uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, nn::capsrv::detail::ScreenShotAttributeEx0 attribute, const UserIdList& userIdList) NN_NOEXCEPT;
        nn::Result CancelTakingScreenShot(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
        nn::Result SetTakingScreenShotCancelState(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
        nn::Result NotifyTakingScreenShotRefused(nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result NotifyTakingScreenShotFailed(nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result OpenRawScreenShotReadStream(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT;
        nn::Result ReadRawScreenShotReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset) NN_NOEXCEPT;

        nn::Result SetupOverlayMovieThumbnail(const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result CreateProtoMovieMetaDataNv12Ex2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outBuffer, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
        nn::Result CreateProtoMovieMetaDataRgbaEx2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::InBuffer& imageRgba, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
    private:
        nn::Result RequestTakingScreenShotImpl(uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, const nn::capsrv::ScreenShotAttribute& attribute, const UserIdList& userIdList) NN_NOEXCEPT;
        nn::Result CreateProtoMovieMetaDataNv12Impl(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outBuffer, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotAttribute& attribute, const nn::capsrv::AppletData* pAppletData, const nn::capsrv::ApplicationData* pApplicationData) NN_NOEXCEPT;
    };

}}}
