﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "visrv_ScreenShotControlServiceImpl.h"

#if defined(NN_CAPSRV_USE_HIPC)
#include <nn/sf/sf_ObjectFactory.h> // NOLINT(analysis/include)
#include <nn/sf/sf_HipcServer.h>
#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)
#include <nn/sf/sf_ObjectFactory.h> // NOLINT(analysis/include)
#else
#error NotSupported
#endif

namespace nn{ namespace capsrv{ namespace server{

#if defined(NN_CAPSRV_USE_HIPC)

    class ScreenShotControlServerManager
    {
    public:
        static const uint32_t   RealtimeSessionCountMax = 4;
        static const uint32_t   SessionCountMax = 4;
        static const int        PortCountMax    = 1;

        typedef nn::sf::UnmanagedServiceObject<nn::capsrv::sf::IScreenShotControlService, ScreenShotControlServiceImpl> ServiceHolderType;

        typedef nn::sf::HipcSimpleAllInOneServerManager<RealtimeSessionCountMax, 0> RealtimeIpcServerManager;

        class IpcServerManager
            : public nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax, PortCountMax>
        {
        public:
            explicit IpcServerManager(nn::sf::HipcServerSessionManagerCommonBase* pRealtimeServerManager) NN_NOEXCEPT
                : m_pRealtimeServerManager(pRealtimeServerManager)
            {
            }
        private:
            nn::sf::HipcServerSessionManagerCommonBase* m_pRealtimeServerManager;
            virtual nn::sf::HipcServerSessionManagerCommonBase* GetHipcServerSessionManagerCommonBase(uint32_t tag) NN_NOEXCEPT NN_OVERRIDE;
        };

    public:
        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void StartServer() NN_NOEXCEPT;
        void StopServer() NN_NOEXCEPT;

        void RunServer() NN_NOEXCEPT;
        void RunRealtimeServer() NN_NOEXCEPT;

    private:
        nn::util::optional<ServiceHolderType> m_ServiceHolder;
        nn::util::optional<RealtimeIpcServerManager> m_RealtimeServerManager;
        nn::util::optional<IpcServerManager>  m_ServerManager;
        nn::os::EventType                     m_IsIdleEvent;

    };

#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)

    class ScreenShotControlServerManager
    {
        typedef nn::sf::UnmanagedServiceObject<nn::capsrv::sf::IScreenShotControlService, ScreenShotControlServiceImpl> ServiceHolderType;
    public:
        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::capsrv::sf::IScreenShotControlService> GetPointer();

    private:
        nn::util::optional<ServiceHolderType> m_ServiceHolder;
    };

#endif

}}}
