﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../capsrvServer_Config.h"
#include "../../capture/capsrv_CaptureModule.h"
#include "../../capture/capsrv_MemoryPool.h"
#include "../../capture/capsrv_ImageBuffer.h"
#include "../../capture/capsrv_DisplayBuffer.h"
#include "../../capture/capsrv_DisplayCapture.h"

namespace nn{ namespace capsrv{ namespace server{

    class ScreenShotCaptureModule
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        capture::CaptureModule* GetModule() NN_NOEXCEPT
        {
            return m_pModule;
        }

        nn::vi::LayerStack GetDefaultScreenShotLayerStack() const NN_NOEXCEPT
        {
            return m_ScreenShot.defaultLayerStack;
        }

        capture::DisplayCapture* GetScreenShotFullSizeCapture() NN_NOEXCEPT
        {
            return &m_ScreenShot.fullSizeCapture;
        }

        capture::ImageBuffer* GetScreenShotOverlayThumbnailImage() NN_NOEXCEPT
        {
            return &m_ScreenShot.overlayThumbnail;
        }

        capture::ImageBuffer* GetScreenShotViewerThumbnailImage() NN_NOEXCEPT
        {
            return &m_ScreenShot.viewerThumbnail;
        }

        capture::DisplayCapture* GetRawScreenShotCapture() NN_NOEXCEPT
        {
            return &m_DebugScreenShot.capture;
        }

        void FlushKeepPresentationBuffer() NN_NOEXCEPT
        {
            m_DebugScreenShot.imageBuffer.FlushCache();
        }

    private:
        capture::CaptureModule* m_pModule;
        capture::MemoryPool m_MemoryPool;

        struct ScreenShot
        {
            capture::DisplayCapture fullSizeCapture;

            capture::ImageBuffer   fullSizeY;
            capture::ImageBuffer   fullSizeU;
            capture::ImageBuffer   fullSizeV;
            capture::DisplayBuffer fullSizeBuffer;

            capture::ImageBuffer   overlayThumbnail;
            capture::ImageBuffer   viewerThumbnail;

            nn::vi::LayerStack     defaultLayerStack;
        } m_ScreenShot;

        // tma からの生画像キャプチャ用
        struct DebugScreenShot
        {
            capture::DisplayCapture capture;
            capture::ImageBuffer    imageBuffer;
            capture::DisplayBuffer  displayBuffer;
        } m_DebugScreenShot;
    };

}}}
