﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "amsrv_ScreenShotApplicationServiceImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_ScreenShotControl.h>
#include <nn/capsrv/capsrv_SystemReservedInfo.h>
#include <nn/am/service/am_AccountWrapper.h>

#include "../capsrvServer_Config.h"
#include "../detail/capsrvServer_ScreenShotAttributeUtility.h"

namespace nn{ namespace capsrv{ namespace server{

    nn::Result ScreenShotApplicationServiceImpl::SaveScreenShotImpl(
        nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry,
        const nn::sf::InBuffer& imageBuffer,
        const nn::capsrv::detail::ScreenShotAttributeEx0& attribute,
        const nn::capsrv::UserIdList& userIdList,
        nn::applet::AppletResourceUserId aruid,
        nn::capsrv::OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT
    {
        NN_CAPSRV_LOG_DEV("  aruid=%lld\n", aruid.lower);

        const void* pImageData = imageBuffer.GetPointerUnsafe();
        size_t imageDataSize   = imageBuffer.GetSize();
        NN_RESULT_THROW_UNLESS(
            pImageData != nullptr && imageDataSize > 0,
            ResultScreenShotInvalidData()
        );

        NN_RESULT_THROW_UNLESS(aruid != nn::applet::AppletResourceUserId::GetInvalidId(), ResultAlbumError());
        NN_RESULT_THROW_UNLESS(attribute.size == ScreenShotSize_1280x720, ResultScreenShotInvalidSize());
        NN_RESULT_THROW_UNLESS(imageDataSize >= 4 * ScreenShotWidth * ScreenShotHeight, ResultScreenShotInvalidData());

        return capsrv::SaveScreenShotEx2ViaAm(outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest);
    }

    nn::Result ScreenShotApplicationServiceImpl::SaveScreenShot(
        nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry,
        const nn::sf::InBuffer& imageBuffer,
        nn::capsrv::ScreenShotSizeType size,
        nn::applet::AppletResourceUserId aruid,
        nn::capsrv::OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT
    {
        NN_CAPSRV_IPC_TRACE_SU(SaveScreenShot);
        capsrv::detail::ScreenShotAttributeEx0 attribute = {};
        attribute.SetDefault();
        attribute.description = AlbumFileDescription_ScreenShotSaved;
        attribute.size = size;
        // Uid 情報をリストアップして vi に渡す
        UserIdList userIdList = {};
        am::service::GetOpenUserIdList(&userIdList);
        return SaveScreenShotImpl(outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest);
    }

    nn::Result ScreenShotApplicationServiceImpl::SaveScreenShotEx0(
        nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry,
        const nn::sf::InBuffer& imageBuffer,
        nn::capsrv::detail::ScreenShotAttributeEx0 attribute,
        nn::applet::AppletResourceUserId aruid,
        nn::capsrv::OverlayNotificationRequestType overlayRequest
    ) NN_NOEXCEPT
    {
        NN_CAPSRV_IPC_TRACE_SU(SaveScreenShotEx0);
        // Uid 情報をリストアップして vi に渡す
        UserIdList userIdList = {};
        am::service::GetOpenUserIdList(&userIdList);
        return SaveScreenShotImpl(outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest);
    }

    nn::Result ScreenShotApplicationServiceImpl::SaveScreenShotEx2(
        nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry,
        const nn::sf::InBuffer& imageBuffer,
        nn::capsrv::detail::ScreenShotAttributeEx0 attribute,
        const nn::capsrv::UserIdList& userIdList,
        nn::applet::AppletResourceUserId aruid,
        nn::capsrv::OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT
    {
        NN_CAPSRV_IPC_TRACE_SU(SaveScreenShotEx2);
        // アプリから受け取った Uid 情報をそのまま vi に渡す
        return SaveScreenShotImpl(outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest);
    }

    //-------------------------------------------------------------------------------------

}}}
