﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "amsrv_ScreenShotApplicationServiceImpl.h"

#if defined(NN_CAPSRV_USE_HIPC)
#include <nn/sf/sf_ObjectFactory.h> // NOLINT(analysis/include)
#include <nn/sf/sf_HipcServer.h>
#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)
#include <nn/sf/sf_ObjectFactory.h> // NOLINT(analysis/include)
#else
#error NotSupported
#endif

namespace nn{ namespace capsrv{ namespace server{

#if defined(NN_CAPSRV_USE_HIPC)

    class ScreenShotApplicationServerManager
    {
    public:
        static const uint32_t   SessionCountMax = 8;
        static const int        PortCountMax    = 1; // caps:su

        typedef nn::sf::UnmanagedServiceObject<nn::capsrv::sf::IScreenShotApplicationService, ScreenShotApplicationServiceImpl> ApplicationServiceHolderType;
        typedef nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax, PortCountMax> ServerManagerType;

    public:
        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void StartServer() NN_NOEXCEPT;
        void StopServer() NN_NOEXCEPT;

        void RunServer() NN_NOEXCEPT;

    private:
        nn::util::optional<ApplicationServiceHolderType> m_ApplicationServiceHolder;
        nn::util::optional<ServerManagerType> m_ServerManager;
        nn::os::EventType                     m_IsIdleEvent;

    };

#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)

    class ScreenShotApplicationServerManager
    {
        typedef nn::sf::UnmanagedServiceObject<nn::capsrv::sf::IScreenShotApplicationService, ScreenShotServiceImpl> ApplicationServiceHolderType;
    public:
        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::capsrv::sf::IScreenShotApplicationService> GetPointerForApplication() NN_NOEXCEPT;

    private:
        nn::util::optional<ApplicationServiceHolderType> m_ApplicationServiceHolder;
    };

#endif

}}}
