﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_TakeScreenShot2.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_ScreenShotContext.h"
#include "action/visrv_GenerateAlbumFileId.h"
#include "action/visrv_AcquireDisplayCaptureYuv.h"
#include "action/visrv_CheckScreenShotNotCanceled.h"
#include "action/visrv_DownsampleForOverlayThumbnail.h"
#include "action/visrv_SetOverlayScreenShotThumbnail.h"
#include "action/visrv_NotifyThumbnailReadyToOverlayDisp.h"
#include "action/visrv_DownsampleForViewerThumbnail.h"
#include "action/visrv_EncodeViewerThumbnailJpeg.h"
#include "action/visrv_CreateExifBuilder.h"
#include "action/visrv_EncodeScreenShotJpegYuv.h"
#include "action/visrv_CalculateMakerNoteRange.h"
#include "action/visrv_SaveScreenShotFile.h"
#include "action/visrv_NotifyScreenShotResultToOverlayDisp.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    namespace {
        nn::Result TakeScreenShotImpl(ScreenShotContext& context) NN_NOEXCEPT
        {
            NN_RESULT_DO(action::GenerateAlbumFileId(context));

            NN_RESULT_DO(action::AcquireDisplayCaptureYuv(context));
            NN_UTIL_SCOPE_EXIT{ action::ReleaseDisplayCaptureYuv(context); };

            // キャンセルされているかチェック
            NN_RESULT_DO(action::CheckScreenShotNotCanceled(context));

            // オーバーレイに通知
            {
                NN_RESULT_DO(action::DownsampleForOverlayThumbnail(context));
                NN_RESULT_DO(action::SetOverlayScreenShotThumbnail(context));
                action::NotifyThumbnailReadyToOverlayDisp(context); // 通知失敗は無視する
            }

            // PhotoViewer 用サムネイルを作成
            NN_RESULT_DO(action::DownsampleForViewerThumbnail(context));
            NN_RESULT_DO(action::EncodeViewerThumbnailJpeg(context));

            // Jpeg データ作成
            {
                NN_RESULT_DO(action::CreateExifBuilder(context));
                NN_UTIL_SCOPE_EXIT{ action::DestroyExifBuilder(context); }; // エンコードしたら破棄する

                NN_RESULT_DO(action::EncodeScreenShotJpegYuv(context));
            }

            NN_RESULT_DO(action::CalculateMakerNoteRange(context));
            NN_RESULT_DO(action::SaveScreenShotFile(context));

            NN_RESULT_SUCCESS;
        }
    }

    nn::Result TakeScreenShot(ScreenShotContext& context) NN_NOEXCEPT
    {
        auto result = TakeScreenShotImpl(context);
        {
            NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
            NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, Result);
            NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, Result, result);
        }
        NN_RESULT_DO(action::NotifyScreenShotReultToOverlayDisp(context));
        NN_RESULT_SUCCESS;
    }


}}}}
